#
#------------------------------------------------------------------------------
# Copyright (c) 2013-2014, Christian Therien
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------
#
# all_tests.py - This file is part of the PySptools package.
#

"""
Call all the test_*.py
"""

import sys
if sys.version_info[:2] == (2,7):
    from pysptools.tests import test_cls, test_detect, test_dnoise, test_vd, test_hull, \
	test_pwc, test_spectro, test_eea
if sys.version_info[:2] == (3,3):
    from pysptools.tests import test_cls, test_detect, test_dnoise, test_vd, test_pwc, test_eea


def all_tests_P2_7():
    try:
        print('====> testing test_cls')
        test_cls.tests()
    except Exception:
        print('**** Error in test: test_cls')
    try:
        print('====> testing test_detect')
        test_detect.tests()
    except Exception:
        print('**** Error in test: test_detect')
    try:
        print('====> testing test_dnoise')
        test_dnoise.tests()
    except Exception:
        print('**** Error in test: test_dnoise')
    try:
        print('====> testing test_vd')
        test_vd.tests()
    except Exception:
        print('**** Error in test: test_vd')
    try:
        print('====> testing test_hull')
        test_hull.tests()
    except Exception:
        print('**** Error in test: test_hull')
    try:
        print('====> testing test_pwc')
        test_pwc.tests()
    except Exception:
        print('**** Error in test: test_pwc')
    try:
        print('====> testing test_spectro')
        test_spectro.tests()
    except Exception:
        print('**** Error in test: test_spectro')
    try:
        print('====> testing test_eea')
        test_eea.tests()
    except Exception:
        print('**** Error in test: test_eea')


def all_tests_P3_3():
    try:
        print('====> testing test_cls')
        test_cls.tests()
    except Exception:
        print('**** Error in test: test_cls')
    try:
        print('====> testing test_detect')
        test_detect.tests()
    except Exception:
        print('**** Error in test: test_detect')
    try:
        print('====> testing test_dnoise')
        test_dnoise.tests()
    except Exception:
        print('**** Error in test: test_dnoise')
    try:
        print('====> testing test_vd')
        test_vd.tests()
    except Exception:
        print('**** Error in test: test_vd')
    try:
        print('====> testing test_pwc')
        test_pwc.tests()
    except Exception:
        print('**** Error in test: test_pwc')
    try:
        print('====> testing test_eea')
        test_eea.tests()
    except Exception:
        print('**** Error in test: test_eea')


if __name__ == '__main__':
    import sys
    if sys.version_info[:2] == (2,7):
        all_tests_P2_7()
    if sys.version_info[:2] == (3,3):
        all_tests_P3_3()
