#
import os
import os.path as osp
import numpy as np
import matplotlib.pyplot as plt

import pysptools.formatting as fmt

# These are used for debugging. I have a better version that will be released.

def plot_image(data, path, R, G, B, suffix=None):
    data = fmt.normalize(data)
    img = np.zeros((data.shape[0],data.shape[1],3), dtype=np.float)
    for i in xrange(data.shape[0]):
        for j in xrange(data.shape[1]):
            img[i,j] = data[i,j,R], data[i,j,G], data[i,j,B]
    plt.ioff()
    if suffix == None:
        fout = osp.join(path, 'image.png')
    else:
        fout = osp.join(path, 'image_{0}.png'.format(suffix))
    plt.imsave(fout, img)


def display(data, R, G, B):
    data = fmt.normalize(data)
    img = np.zeros((data.shape[0],data.shape[1],3), dtype=np.float)
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            img[i,j] = data[i,j,R], data[i,j,G], data[i,j,B]
    plt.imshow(img)
