#
#------------------------------------------------------------------------------
# Copyright (c) 2013-2014, Christian Therien
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------
#
# test_kmeans.py - This file is part of the PySptools package.
#

"""
The following class is tested:
    KMeans
"""

import os.path as osp
import pysptools.util as util
import pysptools.classification as cls


def tests_P2_7():
    import pysptools.util as util
    data_path = '../data1'
    project_path = '../'
    result_path = osp.join(project_path, 'results')
    sample = 'SAMSON_part.hdr'
    #sample = 'hematite.hdr'
    #sample = '92AV3C.hdr'

    data_file = osp.join(data_path, sample)
    data, info = util.load_ENVI_file(data_file)
    #data = np.fliplr(data)

    km = cls.KMeans()
    km.predict(data, 5)
    km.plot(result_path, colorMap='jet')


def tests_P3_3():
    import json
    import numpy as np
    data_path = r'..\data1'
    project_path = '..\\'
    result_path = osp.join(project_path, 'results')
    sample = 'SAMSON_part'

    # load the cube
    data_file = osp.join(data_path, sample+'.jdata')
    with open(data_file, 'r') as content_file:
        data = np.array(json.loads(content_file.read()))
    info_file = osp.join(data_path, sample+'.jhead')
    with open(info_file, 'r') as content_file:
        info = json.loads(content_file.read())

    km = cls.KMeans()
    km.predict(data, 5)
    km.plot(result_path, colorMap='jet')


def tests():
    import sys
    if sys.version_info[:2] == (2,7):
        tests_P2_7()
    if sys.version_info[:2] == (3,3):
        tests_P3_3()


if __name__ == '__main__':
    import sys
    print(sys.version_info)
    if sys.version_info[:2] == (2,7):
        tests_P2_7()
    if sys.version_info[:2] == (3,3):
        tests_P3_3()
