#
#------------------------------------------------------------------------------
# Copyright (c) 2013-2014, Christian Therien
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------
#
# utests.py - This file is part of the PySptools package.
#

import unittest
import numpy as np
from pysptools.abundance_maps import UCLS, NNLS, FCLS
from types import *

# B suffix == bad
# G suffix == good

class TestAmapsError(unittest.TestCase):

    def setUp(self):
        pass

    def runTest(self):
        print '==> runTest: TestAmapsError'
        self.test_not_ndarray()
        self.test_plot()
        self.test_wrong_input_dim()


    def test_not_ndarray(self):
        data_G = np.zeros((2,2,2,2))
        data_B = [1,2]
        E_G = np.zeros((2,2))
        E_B = 123

        amp = UCLS()
        # err1
        with self.assertRaises(RuntimeError):
            amp.map(data_B,E_G)
        # err2
        with self.assertRaises(RuntimeError):
            amp.map(data_G,E_B)

        amp = NNLS()
        # err1
        with self.assertRaises(RuntimeError):
            amp.map(data_B,E_G)
        # err2
        with self.assertRaises(RuntimeError):
            amp.map(data_G,E_B)

        amp = FCLS()
        # err1
        with self.assertRaises(RuntimeError):
            amp.map(data_B,E_G)
        # err2
        with self.assertRaises(RuntimeError):
            amp.map(data_G,E_B)


    def test_plot(self):
        amp = UCLS()
        # err10
        with self.assertRaises(RuntimeError):
            amp.plot('../results')
        # err11
        amp.amap = np.array([1,2])
        with self.assertRaises(TypeError):
            amp.plot('../results', suffix=[1,2])

        amp = NNLS()
        # err10
        with self.assertRaises(RuntimeError):
            amp.plot('../results')
        # err11
        amp.amap = np.array([1,2])
        with self.assertRaises(TypeError):
            amp.plot('../results', suffix=[1,2])

        amp = FCLS()
        # err10
        with self.assertRaises(RuntimeError):
            amp.plot('../results')
        # err11
        amp.amap = np.array([1,2])
        with self.assertRaises(TypeError):
            amp.plot('../results', suffix=[1,2])


    def test_wrong_input_dim(self):
        data_B = np.zeros((2,2,2,2))
        data_G = np.zeros((3,3,3))
        E_G = np.zeros((2,2))
        E_B = np.zeros((1,2,1,2))

        amp = UCLS()
        # err3
        with self.assertRaises(RuntimeError):
            amp.map(data_B,E_G)
        # err4
        with self.assertRaises(RuntimeError):
            amp.map(data_G,E_B)

        amp = NNLS()
        # err3
        with self.assertRaises(RuntimeError):
            amp.map(data_B,E_G)
        # err4
        with self.assertRaises(RuntimeError):
            amp.map(data_G,E_B)

        amp = FCLS()
        # err3
        with self.assertRaises(RuntimeError):
            amp.map(data_B,E_G)
        # err4
        with self.assertRaises(RuntimeError):
            amp.map(data_G,E_B)


if __name__ == '__main__':
    unittest.main()

