#
#------------------------------------------------------------------------------
# Copyright (c) 2013-2014, Christian Therien
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------
#
# utests.py - This file is part of the PySptools package.
#

import unittest
import numpy as np
from pysptools.material_count import HfcVd, HySime
from types import *

class TestHfcVdError(unittest.TestCase):

    def setUp(self):
        self.data1 = np.zeros((2,2,2,2))
        self.data2 = [1,2]
        self.data3 = np.zeros((3,3,3))
        self.far1 = 0.1
        self.far7 = [0.5,2]

    def runTest(self):
        print '==> runTest: TestHfcVdError'
        self.test_not_ndarray()
        self.test_wrong_input_dim()
        self.test_far_wrong_type()
        self.test_far_wrong_value()

    def test_not_ndarray(self):
        vd = HfcVd()
        # err1
        with self.assertRaises(RuntimeError):
            vd.count(self.data2)

    def test_wrong_input_dim(self):
        vd = HfcVd()
        # err3
        with self.assertRaises(RuntimeError):
            vd.count(self.data1)

    def test_far_wrong_type(self):
        vd = HfcVd()
        # err5
        with self.assertRaises(TypeError):
            vd.count(self.data3, far=self.far1)

    def test_far_wrong_value(self):
        vd = HfcVd()
        # err8
        with self.assertRaises(ValueError):
            vd.count(self.data3, far=self.far7)


class TestHySimeError(unittest.TestCase):

    def setUp(self):
        self.data1 = np.zeros((2,2,2,2))
        self.data2 = [1,2]
        #self.data3 = np.zeros((3,3,3))

    def runTest(self):
        print '==> runTest: TestHySimeError'
        self.test_not_ndarray()
        self.test_wrong_input_dim()

    def test_not_ndarray(self):
        vd = HySime()
        # err1
        with self.assertRaises(RuntimeError):
            vd.count(self.data2)

    def test_wrong_input_dim(self):
        vd = HySime()
        # err3
        with self.assertRaises(RuntimeError):
            vd.count(self.data1)


if __name__ == '__main__':
    unittest.main()

