#
#------------------------------------------------------------------------------
# Copyright (c) 2013-2014, Christian Therien
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------
#
# all_utests.py - This file is part of the PySptools package.
#


"""
Call all the utests.py
"""

import unittest

import pysptools.abundance_maps.utests as uamap
import pysptools.classification.utests as ucls
import pysptools.detection.utests as udetect
import pysptools.distance.utests as udst
import pysptools.eea.utests as ueea
import pysptools.material_count.utests as ucnt
import pysptools.noise.utests as unoise

if __name__ == '__main__':
    suite = unittest.TestSuite()
    # abundance_maps
    suite.addTest(uamap.TestAmapsError())
    # classifiers
    suite.addTest(ucls.TestClassifierError())
    # detection
    suite.addTest(udetect.TestDetectionError())
    # distance
    suite.addTest(udst.TestSAMFunction())
    suite.addTest(udst.TestSIDFunction())
    suite.addTest(udst.TestChebyshevFunction())
    suite.addTest(udst.TestNormXCorrFunction())
    suite.addTest(udst.TestSafeDistance())
    # eea
    suite.addTest(ueea.TestEeaError())
    # material_count
    suite.addTest(ucnt.TestHfcVdError())
    suite.addTest(ucnt.TestHySimeError())
    # noise
    suite.addTest(unoise.TestSavitzkyGolayError())
    suite.addTest(unoise.TestWhitenError())

    runner=unittest.TextTestRunner()
    runner.run(suite)
