#
#------------------------------------------------------------------------------
# Copyright (c) 2013-2014, Christian Therien
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------
#
# test_SVC.py - This file is part of the PySptools package.
#



import os
import os.path as osp

import pysptools.classification as cls
import pysptools.util as util

def remove_bands(M):
    """
    Remove the bands with atmospheric
    scattering.
    Remove:
        [0..4]
        [102..110]
        [148..169]
        [211..end]
    """
    p1 = list(range(5,102))
    p2 = list(range(111,148))
    p3 = list(range(170,211))
    Mp = M[:,:,p1+p2+p3]
    return Mp

def test_SVC(data, result_path):
    r = cls.ROIs()
    r.add('Alfalfa', {'poly': ((67,98),(73,98),(75,101),(70,101))})
    r.add('Corn-notill', {'rec': (33,31,41,56)})
    r.add('Corn-min', {'rec': (63,6,71,21)}, {'rec': (128,20,134,46)})
    r.add('Corn', {'poly': ((35,7),(35,5),(48,10),(48,23),(45,22),(44,16),(35,10),(35,5))})
    r.add('Grass/Pasture', {'rec': (75,4,85,21)})
    r.add('Grass/Trees', {'rec': (48,28,70,35)})
    r.add('Grass/pasture-mowed', {'rec': (73,109,78,112)})
    r.add('Hay-windrowed', {'rec': (39,124,59,138)})
    r.add('Soybeans-notill', {'rec': (42,78,63,92)})
    r.add('Soybean-min-till', {'rec': (78,34,111,45)}, {'rec': (3,112,17,117)}, {'rec': (80,51,95,71)})
    r.add('Soybean-clean', {'rec': (52,5,58,24)})
    r.add('Wheat', {'rec': (119,26,124,46)})
    r.add('Woods', {'rec': (121,91,137,121)})
    r.add('Stone-steel towers', {'poly': ((14,47),(23,44),(24,49),(16,52),(14,47))})

    # These one don't perform well
    #r.add('Oats', {'rec': (63,23,71,24)})
    #r.add('Bldg-Grass-Tree-Drives', {'rec': (18,27,27,34)})

    svm = cls.SVC()
    svm.fit(data, r, class_weight={0:1,1:10,2:10,3:10,4:10,5:10,6:10,7:10,8:10,9:10,10:10,11:10,12:10,13:10,14:10})
#    svm.fit(data, r, class_weight={0:1,1:2000,2:100,3:100,4:100,5:100,6:100,7:100,8:100,9:100,10:100,11:100,12:100,13:10})
#    svm.fit(data, r, class_weight={0:1,1:1000,2:1000,3:1000,4:1000,5:1000,6:1000,7:1000,8:1000,9:1000,10:1000,11:1000,12:1000,13:1000})
#    svm.fit(data, r, class_weight={0:1,1:3000,2:3000,3:3000,4:3000,5:3000,6:3000,7:3000,8:3000,9:3000,10:3000,11:3000,12:3000,13:3000})
#    svm.fit(data, r, class_weight={0:1,1:10,2:50,3:10,4:10,5:10})
#    svm.fit(data, r, class_weight={0:1,1:10,2:10,3:10})
    svm.classify(data)
    svm.plot_ROIs(result_path, labels=r.get_labels(), colorMap='Paired')
    svm.plot(result_path, labels=r.get_labels(), colorMap='Paired')


def tests_P2_7():
    data_path = '../data1'
    project_path = '../'
    result_path = osp.join(project_path, 'results')
    sample = '92AV3C.hdr'

    data_file = osp.join(data_path, sample)
    data, info = util.load_ENVI_file(data_file)
    data = remove_bands(data)

    test_SVC(data, result_path)


def tests_P3_3():
    import json
    import numpy as np
    data_path = '../data1'
    project_path = '../'
    result_path = osp.join(project_path, 'results')
    sample = '92AV3C'
    spec_lib_path = '../data'
    spec_lib_hdr = 'speclib1'
    if osp.exists(result_path) == False:
        os.makedirs(result_path)

    data_file = osp.join(data_path, sample+'.jdata')
    with open(data_file, 'r') as content_file:
        data = np.array(json.loads(content_file.read()))

    info_file = osp.join(data_path, sample+'.jhead')
    with open(info_file, 'r') as content_file:
        info = json.loads(content_file.read())

    data = remove_bands(data)

    test_SVC(data, result_path)


def tests():
    import sys
    if sys.version_info[:2] == (2,7):
        tests_P2_7()
    if sys.version_info[:2] == (3,3):
        tests_P3_3()

if __name__ == '__main__':
    import sys
    print(sys.version_info)
    if sys.version_info[:2] == (2,7):
        tests_P2_7()
    if sys.version_info[:2] == (3,3):
        tests_P3_3()
