import os
import gnupg

from .utils import which


def create_key_input(gpg, passphrase, testing=False):
    key_input = gpg.gen_key_input(
        name_real='Pysswords',
        name_email='pysswords@pysswords',
        name_comment='Autogenerated by Pysswords',
        passphrase=passphrase,
        testing=testing
    )
    return key_input


def create_gpg(binary, database_path, passphrase):
    gnupg_path = os.path.join(database_path, ".gnupg")
    gpg = gnupg.GPG(which(binary), homedir=gnupg_path)
    gpg.gen_key(create_key_input(gpg, passphrase))
    return gpg


def load_gpg(binary, database_path):
    gnupg_path = os.path.join(database_path, ".gnupg")
    gpg = gnupg.GPG(which(binary), homedir=gnupg_path)
    return gpg
