/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleArrayTest;

public class ArrayElementDivide {
    public IDoubleArray divideToNewDense(IDoubleArray a, IDoubleArray b) {
        IDoubleArray target = a.copy();
        this.divideDense(a, b, target);
        return target;
    }

    public IDoubleArray divideToNewSparse(IDoubleArray a, IDoubleArray b) {
        IDoubleArray target = a.copy();
        this.divideSparse(a, b, target);
        return target;
    }

    public void divideToSparse(IDoubleArray a, IDoubleArray b) {
        this.divideSparse(a, b, a);
    }

    public void divideToDense(IDoubleArray a, IDoubleArray b) {
        this.divideDense(a, b, a);
    }

    public void divideDense(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        int colsA = a.columns();
        int rowsA = a.rows();
        int j = 0;
        while (j < rowsA) {
            int i = 0;
            while (i < colsA) {
                target.set(i, j, a.get(i, j) / b.get(i, j));
                ++i;
            }
            ++j;
        }
    }

    public void divideSparse(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        if (a != target) {
            target.zero();
        }
        IDoubleIterator it = a.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            target.set(i, j, it.get() / b.get(i, j));
            it.advance();
        }
    }
}

