/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.algebra.IComplexNumber;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleArrayTest;

public class InnerProduct {
    boolean complexConjugate;

    public InnerProduct(boolean _complexConjugate) {
        this.complexConjugate = _complexConjugate;
    }

    public double innerProduct(IDoubleArray a, IDoubleArray b) {
        DoubleArrayTest.assertOrder(a, 1);
        DoubleArrayTest.assertOrder(b, 1);
        double result = 0.0;
        int i = 0;
        while (i < a.size()) {
            result += a.get(i) * b.get(i);
            ++i;
        }
        return result;
    }

    public double innerProductSparseSparse(IDoubleArray a, IDoubleArray b) {
        DoubleArrayTest.assertOrder(a, 1);
        DoubleArrayTest.assertOrder(b, 1);
        double result = 0.0;
        SynchronousPairIterator it = new SynchronousPairIterator(a, b);
        while (it.hasNext()) {
            result += it.get1() * it.get2();
            it.advance();
        }
        return result;
    }

    public double innerProductSparseDense(IDoubleArray asparse, IDoubleArray bdense) {
        DoubleArrayTest.assertOrder(asparse, 1);
        DoubleArrayTest.assertOrder(bdense, 1);
        double result = 0.0;
        IDoubleIterator it = asparse.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.getIndex();
            double ai = it.get();
            double bi = bdense.get(i);
            result += ai * bi;
            it.advance();
        }
        return result;
    }

    public double innerProduct(IDoubleArray a, IDoubleArray b, IDoubleArray w) {
        DoubleArrayTest.assertOrder(a, 1);
        DoubleArrayTest.assertOrder(b, 1);
        DoubleArrayTest.assertOrder(w, 1);
        double result = 0.0;
        int i = 0;
        while (i < a.size()) {
            result += a.get(i) * b.get(i) * w.get(i);
            ++i;
        }
        return result;
    }

    public double innerProductSparseDense(IDoubleArray asparse, IDoubleArray bdense, IDoubleArray w) {
        DoubleArrayTest.assertOrder(asparse, 1);
        DoubleArrayTest.assertOrder(bdense, 1);
        DoubleArrayTest.assertOrder(w, 1);
        double result = 0.0;
        IDoubleIterator it = asparse.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.getIndex();
            double ai = it.get();
            double bi = bdense.get(i);
            double wi = w.get(i);
            result += ai * bi * wi;
            it.advance();
        }
        return result;
    }

    public double innerProductSparseSparse(IDoubleArray a, IDoubleArray b, IDoubleArray w) {
        DoubleArrayTest.assertOrder(a, 1);
        DoubleArrayTest.assertOrder(b, 1);
        DoubleArrayTest.assertOrder(w, 1);
        double result = 0.0;
        SynchronousPairIterator it = new SynchronousPairIterator(a, b);
        while (it.hasNext()) {
            result += it.get1() * w.get(it.getIndex()) * it.get2();
            it.advance();
        }
        return result;
    }

    public IComplexNumber innerProduct(IComplexArray a, IComplexArray b, IDoubleArray w, IComplexNumber target) {
        double sumRe = 0.0;
        double sumIm = 0.0;
        int i = 0;
        while (i < a.size()) {
            double aRe = a.getRe(i);
            double aIm = a.getIm(i);
            double bRe = b.getRe(i);
            double bIm = b.getIm(i);
            if (this.complexConjugate) {
                bIm = -bIm;
            }
            if (w != null) {
                double wRe = w.get(i);
                aRe *= wRe;
                aIm *= wRe;
            }
            sumRe += aRe * bRe - aIm * bIm;
            sumIm += aRe * bIm + aIm * bRe;
            ++i;
        }
        target.setComplex(sumRe, sumIm);
        return target;
    }

    public IComplexNumber innerProduct(IComplexArray a, IComplexArray b, IComplexNumber target) {
        return this.innerProduct(a, b, null, target);
    }

    class SynchronousPairIterator {
        private IDoubleIterator itA;
        private IDoubleIterator itB;
        private int i;
        private double va;
        private double vb;
        private boolean hasNext = true;

        public SynchronousPairIterator(IDoubleArray _a, IDoubleArray _b) {
            this.itA = _a.nonzeroIterator();
            this.itB = _b.nonzeroIterator();
            this.advance();
        }

        public final void advance() {
            int i1 = this.itA.getIndex();
            int i2 = this.itB.getIndex();
            while (i1 != i2) {
                if (i1 < i2) {
                    if (this.itA.hasNext()) {
                        this.itA.advance();
                        i1 = this.itA.getIndex();
                        continue;
                    }
                    this.hasNext = false;
                    return;
                }
                if (this.itB.hasNext()) {
                    this.itB.advance();
                    i1 = this.itB.getIndex();
                    continue;
                }
                this.hasNext = false;
                return;
            }
            this.i = i1;
            this.va = this.itA.get();
            this.vb = this.itB.get();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public int getIndex() {
            return this.i;
        }

        public double get1() {
            return this.va;
        }

        public double get2() {
            return this.vb;
        }
    }
}

