/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.algebra.InnerProduct;
import stallone.api.API;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.DoubleArrayTest;

public class MatrixProduct {
    InnerProduct ip = new InnerProduct(true);

    public IDoubleArray multiplyToNew(IDoubleArray a, IDoubleArray b) {
        IDoubleArray res;
        if (a.isSparse() && b.isSparse()) {
            res = API.doublesNew.sparseMatrix(a.rows(), b.columns());
            this.multiplySparseSparse(a, b, res);
        } else if (a.isSparse() && !b.isSparse()) {
            res = API.doublesNew.sparseMatrix(a.rows(), b.columns());
            this.multiplySparseDense(a, b, res);
        } else {
            res = API.doublesNew.denseMatrix(a.rows(), b.columns());
            this.multiply(a, b, res);
        }
        return res;
    }

    public IDoubleArray multiply(IDoubleArray a, IDoubleArray b, IDoubleArray res) {
        if (a.isSparse() && b.isSparse()) {
            this.multiplySparseSparse(a, b, res);
        } else if (a.isSparse() && !b.isSparse()) {
            this.multiplySparseDense(a, b, res);
        } else {
            this.multiplyDense(a, b, res);
        }
        return res;
    }

    public void multiplyDense(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        int r = a.columns();
        int colsB = b.columns();
        int rowsA = a.rows();
        DoubleArrayTest.assertCanMultiply(a, b);
        DoubleArrayTest.assertRows(target, a.rows());
        DoubleArrayTest.assertColumns(target, b.columns());
        int l = 0;
        while (l < colsB) {
            int k = 0;
            while (k < rowsA) {
                double val = 0.0;
                int i = 0;
                while (i < r) {
                    val += a.get(k, i) * b.get(i, l);
                    ++i;
                }
                target.set(k, l, val);
                ++k;
            }
            ++l;
        }
    }

    public void multiplySparseDense(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        int colsB = b.columns();
        int rowsA = a.rows();
        DoubleArrayTest.assertCanMultiply(a, b);
        DoubleArrayTest.assertRows(target, a.rows());
        DoubleArrayTest.assertColumns(target, b.columns());
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsB) {
                target.set(i, j, this.ip.innerProductSparseDense(a.viewRow(i), b.viewColumn(j)));
                ++j;
            }
            ++i;
        }
    }

    public void multiplySparseSparse(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        int colsB = b.columns();
        int rowsA = a.rows();
        DoubleArrayTest.assertCanMultiply(a, b);
        DoubleArrayTest.assertRows(target, a.rows());
        DoubleArrayTest.assertColumns(target, b.columns());
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsB) {
                target.set(i, j, this.ip.innerProductSparseSparse(a.viewRow(i), b.viewColumn(j)));
                ++j;
            }
            ++i;
        }
    }

    public IComplexArray multiplyToNew(IComplexArray a, IComplexArray b) {
        IComplexArray res = a.create(a.rows(), b.columns());
        this.multiply(a, b, res);
        return res;
    }

    public void multiply(IComplexArray a, IComplexArray b, IComplexArray target) {
        int r = a.columns();
        int colsB = b.columns();
        int rowsA = a.rows();
        DoubleArrayTest.assertCanMultiply(a, b);
        DoubleArrayTest.assertRows(target, a.rows());
        DoubleArrayTest.assertRows(target, b.columns());
        int l = 0;
        while (l < colsB) {
            int k = 0;
            while (k < rowsA) {
                double sumRe = 0.0;
                double sumIm = 0.0;
                int i = 0;
                while (i < r) {
                    double aRe = a.getRe(k, i);
                    double aIm = a.getIm(k, i);
                    double bRe = b.getRe(i, l);
                    double bIm = b.getIm(i, l);
                    sumRe += aRe * bRe - aIm * bIm;
                    sumIm += aRe * bIm + aIm * bRe;
                    ++i;
                }
                target.setRe(k, l, sumRe);
                target.setIm(k, l, sumIm);
                ++k;
            }
            ++l;
        }
    }

    public void sparseMultiply(IComplexArray a, IComplexArray b, IComplexArray target) {
        int colsB = b.columns();
        int rowsA = a.rows();
        DoubleArrayTest.assertCanMultiply(a, b);
        DoubleArrayTest.assertRows(target, a.rows());
        DoubleArrayTest.assertRows(target, b.columns());
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsB) {
                target.set(i, j, this.ip.innerProductSparseSparse(a, b));
                ++j;
            }
            ++i;
        }
    }
}

