/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.API;
import stallone.api.algebra.ILUDecomposition;
import stallone.api.doubles.IDoubleArray;

public class RealLUDecomposition
implements ILUDecomposition {
    private IDoubleArray luMatrix;
    private int m;
    private int n;
    private int pivotSign;
    private int[] pivots;

    @Override
    public void setMatrix(IDoubleArray matrixA) {
        this.luMatrix = API.doublesNew.matrix(matrixA.rows(), matrixA.columns());
        this.luMatrix.copyFrom(matrixA);
        this.m = matrixA.rows();
        this.n = matrixA.columns();
    }

    @Override
    public void perform() {
        this.pivots = new int[this.m];
        int i = 0;
        while (i < this.m) {
            this.pivots[i] = i;
            ++i;
        }
        this.pivotSign = 1;
        int j = 0;
        while (j < this.n) {
            IDoubleArray LUcolj = this.luMatrix.viewColumn(j).copy();
            int i2 = 0;
            while (i2 < this.m) {
                IDoubleArray LUrowi = this.luMatrix.viewRow(i2);
                int kmax = Math.min(i2, j);
                double s = 0.0;
                int k = 0;
                while (k < kmax) {
                    s += LUrowi.get(k) * LUcolj.get(k);
                    ++k;
                }
                LUcolj.set(i2, LUcolj.get(i2) - s);
                LUrowi.set(j, LUcolj.get(i2));
                ++i2;
            }
            int p = j;
            int i3 = j + 1;
            while (i3 < this.m) {
                if (Math.abs(LUcolj.get(i3)) > Math.abs(LUcolj.get(p))) {
                    p = i3;
                }
                ++i3;
            }
            if (p != j) {
                int k = 0;
                while (k < this.n) {
                    double t = this.luMatrix.get(p, k);
                    this.luMatrix.set(p, k, this.luMatrix.get(j, k));
                    this.luMatrix.set(j, k, t);
                    ++k;
                }
                k = this.pivots[p];
                this.pivots[p] = this.pivots[j];
                this.pivots[j] = k;
                this.pivotSign = -this.pivotSign;
            }
            if (j < this.m && this.luMatrix.get(j, j) != 0.0) {
                double r = this.luMatrix.get(j, j);
                int i4 = j + 1;
                while (i4 < this.m) {
                    this.luMatrix.set(i4, j, this.luMatrix.get(i4, j) / r);
                    ++i4;
                }
            }
            ++j;
        }
    }

    @Override
    public boolean isNonsingular() {
        int j = 0;
        while (j < this.n) {
            if (this.luMatrix.get(j, j) == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    @Override
    public IDoubleArray getL() {
        IDoubleArray X = API.doublesNew.matrix(this.m, this.n);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                if (i > j) {
                    X.set(i, j, this.luMatrix.get(i, j));
                } else if (i == j) {
                    X.set(i, j, 1.0);
                } else {
                    X.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        return X;
    }

    @Override
    public IDoubleArray getU() {
        IDoubleArray X = API.doublesNew.matrix(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i <= j) {
                    X.set(i, j, this.luMatrix.get(i, j));
                } else {
                    X.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        System.arraycopy(this.pivots, 0, p, 0, this.m);
        return p;
    }

    @Override
    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivotSign;
        int j = 0;
        while (j < this.n) {
            d *= this.luMatrix.get(j, j);
            ++j;
        }
        return d;
    }

    public IDoubleArray solve(IDoubleArray B) {
        int b_rows = B.rows();
        int b_cols = B.columns();
        if (b_rows != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        IDoubleArray X = API.doublesNew.matrix(b_rows, b_cols);
        int i = 0;
        while (i < b_rows) {
            int pivotedRow = this.pivots[i];
            int j = 0;
            while (j < b_cols) {
                X.set(i, j, B.get(pivotedRow, j));
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < this.n) {
            int i2 = k + 1;
            while (i2 < this.n) {
                double lu_ik = this.luMatrix.get(i2, k);
                int j = 0;
                while (j < b_cols) {
                    double a = X.get(k, j) * lu_ik;
                    X.set(i2, j, X.get(i2, j) - a);
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            double lu_kk = this.luMatrix.get(k, k);
            int j = 0;
            while (j < b_cols) {
                X.set(k, j, X.get(k, j) / lu_kk);
                ++j;
            }
            int i3 = 0;
            while (i3 < k) {
                double lu_ik = this.luMatrix.get(i3, k);
                int j2 = 0;
                while (j2 < b_cols) {
                    double a = X.get(k, j2) * lu_ik;
                    X.set(i3, j2, X.get(i3, j2) - a);
                    ++j2;
                }
                ++i3;
            }
            --k;
        }
        return X;
    }
}

