/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.algebra.IQRDecomposition;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;

public class RealQRDecomposition
implements IQRDecomposition {
    private IDoubleArray qrMatrix;
    private int m;
    private int n;
    private double[] Rdiag;

    @Override
    public void setMatrix(IDoubleArray matrixA) {
        this.qrMatrix = Doubles.create.array(matrixA.rows(), matrixA.columns());
        this.qrMatrix.copyFrom(matrixA);
        this.m = matrixA.rows();
        this.n = matrixA.columns();
    }

    @Override
    public void perform() {
        this.Rdiag = new double[this.n];
        int k = 0;
        while (k < this.n) {
            double nrm = 0.0;
            int i = k;
            while (i < this.m) {
                nrm = RealQRDecomposition.hypot(nrm, this.qrMatrix.get(i, k));
                ++i;
            }
            if (nrm != 0.0) {
                if (this.qrMatrix.get(k, k) < 0.0) {
                    nrm = -nrm;
                }
                i = k;
                while (i < this.m) {
                    this.qrMatrix.set(i, k, this.qrMatrix.get(i, k) / nrm);
                    ++i;
                }
                this.qrMatrix.set(k, k, this.qrMatrix.get(k, k) + 1.0);
                int j = k + 1;
                while (j < this.n) {
                    double s = 0.0;
                    int i2 = k;
                    while (i2 < this.m) {
                        s += this.qrMatrix.get(i2, k) * this.qrMatrix.get(i2, j);
                        ++i2;
                    }
                    s = -s / this.qrMatrix.get(k, k);
                    i2 = k;
                    while (i2 < this.m) {
                        double a = s * this.qrMatrix.get(i2, k);
                        this.qrMatrix.set(i2, j, this.qrMatrix.get(i2, j) + a);
                        ++i2;
                    }
                    ++j;
                }
            }
            this.Rdiag[k] = -nrm;
            ++k;
        }
    }

    @Override
    public boolean isFullRank() {
        int j = 0;
        while (j < this.n) {
            if (this.Rdiag[j] == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public IDoubleArray getH() {
        IDoubleArray X = Doubles.create.array(this.m, this.n);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                if (i >= j) {
                    X.set(i, j, this.qrMatrix.get(i, j));
                } else {
                    X.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        return X;
    }

    @Override
    public IDoubleArray getR() {
        IDoubleArray X = Doubles.create.array(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i < j) {
                    X.set(i, j, this.qrMatrix.get(i, j));
                } else if (i == j) {
                    X.set(i, j, this.Rdiag[i]);
                } else {
                    X.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        return X;
    }

    @Override
    public IDoubleArray getQ() {
        IDoubleArray X = Doubles.create.array(this.m, this.n);
        int k = this.n - 1;
        while (k >= 0) {
            int i = 0;
            while (i < this.m) {
                X.set(i, k, 0.0);
                ++i;
            }
            X.set(k, k, 1.0);
            int j = k;
            while (j < this.n) {
                if (this.qrMatrix.get(k, k) != 0.0) {
                    double s = 0.0;
                    int i2 = k;
                    while (i2 < this.m) {
                        s += this.qrMatrix.get(i2, k) * X.get(i2, j);
                        ++i2;
                    }
                    s = -s / this.qrMatrix.get(k, k);
                    i2 = k;
                    while (i2 < this.m) {
                        double a = s * this.qrMatrix.get(i2, k);
                        X.set(i2, j, X.get(i2, j) + a);
                        ++i2;
                    }
                }
                ++j;
            }
            --k;
        }
        return X;
    }

    public IDoubleArray solve(IDoubleArray B) {
        int j;
        int b_rows = B.rows();
        int b_cols = B.columns();
        if (b_rows != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        IDoubleArray X = B.copy();
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < b_cols) {
                double s = 0.0;
                int i = k;
                while (i < this.m) {
                    s += this.qrMatrix.get(i, k) * X.get(i, j);
                    ++i;
                }
                s = -s / this.qrMatrix.get(k, k);
                i = k;
                while (i < this.m) {
                    double a = s * this.qrMatrix.get(i, k);
                    X.set(i, j, X.get(i, j) + a);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < b_cols) {
                X.set(k, j, X.get(k, j) / this.Rdiag[k]);
                ++j;
            }
            int i = 0;
            while (i < k) {
                int j2 = 0;
                while (j2 < b_cols) {
                    double a = X.get(k, j2) * this.qrMatrix.get(i, k);
                    X.set(i, j2, X.get(i, j2) - a);
                    ++j2;
                }
                ++i;
            }
            --k;
        }
        return X.viewBlock(0, 0, this.n, b_cols);
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }
}

