/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.coordinates;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;
import stallone.util.Arguments;
import stallone.util.MathTools;

public class CoordinateUtilities3D {
    static long t;

    public static void copy(double[] v1, double[] v2) {
        v2[0] = v1[0];
        v2[1] = v1[1];
        v2[2] = v1[2];
    }

    public static double[] add(double[] v1, double[] v2) {
        double[] v = new double[]{v1[0] + v2[0], v1[1] + v2[1], v1[2] + v2[2]};
        return v;
    }

    public static void increment(double[] v1, double[] v2) {
        v1[0] = v1[0] + v2[0];
        v1[1] = v1[1] + v2[1];
        v1[2] = v1[2] + v2[2];
    }

    public static void decrement(double[] v1, double[] v2) {
        v1[0] = v1[0] - v2[0];
        v1[1] = v1[1] - v2[1];
        v1[2] = v1[2] - v2[2];
    }

    public static double[] addweighted(double a, double[] v1, double b, double[] v2) {
        double[] v = new double[]{a * v1[0] + b * v2[0], a * v1[1] + b * v2[1], a * v1[2] + b * v2[2]};
        return v;
    }

    public static double[] subtract(double[] v1, double[] v2) {
        double[] v = new double[]{v1[0] - v2[0], v1[1] - v2[1], v1[2] - v2[2]};
        return v;
    }

    public static void subtract2(double[] v1, double[] v2, double[] res) {
        res[0] = v1[0] - v2[0];
        res[1] = v1[1] - v2[1];
        res[2] = v1[2] - v2[2];
    }

    public static double[] stretch(double a, double[] v) {
        double[] v1 = new double[]{a * v[0], a * v[1], a * v[2]};
        return v1;
    }

    public static double dotprod(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static double overlap(double[][] V1, double[][] V2) {
        double o = 0.0;
        int i = 0;
        while (i < V1.length) {
            int j = 0;
            while (j < V2.length) {
                o += Math.pow(PrimitiveDoubleTools.dot(CoordinateUtilities3D.normalize(V1[i]), CoordinateUtilities3D.normalize(V2[j])), 2.0);
                ++j;
            }
            ++i;
        }
        return o;
    }

    public static double subspaceOverlap(double[][] V1, double[][] V2) {
        return CoordinateUtilities3D.overlap(V1, V2) / (double)Math.max(V1.length, V2.length);
    }

    public static double superspaceOverlap(double[][] V1, double[][] V2) {
        return CoordinateUtilities3D.overlap(V1, V2) / (double)Math.min(V1.length, V2.length);
    }

    public static double[] crossprod(double[] v1, double[] v2) {
        double[] v = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        return v;
    }

    public static double[] normal0(double[] p1, double[] p2, double[] p3) {
        double[] v21 = CoordinateUtilities3D.subtract(p1, p2);
        double[] v23 = CoordinateUtilities3D.subtract(p3, p2);
        return CoordinateUtilities3D.normalize(CoordinateUtilities3D.crossprod(v21, v23));
    }

    public static double squaredistance(double[] v1, double[] v2) {
        double dx = v1[0] - v2[0];
        double dy = v1[1] - v2[1];
        double dz = v1[2] - v2[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distance(double[] v1, double[] v2) {
        double dx = v1[0] - v2[0];
        double dy = v1[1] - v2[1];
        double dz = v1[2] - v2[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double[] distances(double[][] arr, int[][] partners) {
        double[] res = new double[partners.length];
        int i = 0;
        while (i < res.length) {
            res[i] = CoordinateUtilities3D.distance(arr[partners[i][0]], arr[partners[i][1]]);
            ++i;
        }
        return res;
    }

    public static double distancePointSurface(double[] o, double[] surfv1, double[] surfv2, double[] p) {
        double[] n = CoordinateUtilities3D.crossprod(surfv1, surfv2);
        Object M = new double[][]{PrimitiveDoubleTools.normalize(surfv1), PrimitiveDoubleTools.normalize(surfv2), PrimitiveDoubleTools.normalize(n)};
        M = PrimitiveDoubleTools.transpose(M);
        IDoubleArray arrM = API.doublesNew.array((double[][])M);
        double[] o_new = API.alg.solve(arrM, API.doublesNew.array(o)).getArray();
        double[] p_new = API.alg.solve(arrM, API.doublesNew.array(p)).getArray();
        double[] x = PrimitiveDoubleTools.subtract(p_new, o_new);
        return Math.abs(x[2]);
    }

    public static double angleRad(double[] v1, double[] v2) {
        double sqnorm = Math.sqrt(CoordinateUtilities3D.dotprod(v1, v1) * CoordinateUtilities3D.dotprod(v2, v2));
        if (sqnorm == 0.0) {
            return 0.0;
        }
        return MathTools.acos(MathTools.bound(CoordinateUtilities3D.dotprod(v1, v2) / sqnorm, -1.0, 1.0));
    }

    public static double angleDeg(double[] v1, double[] v2) {
        double a = MathTools.acos(CoordinateUtilities3D.dotprod(v1, v2) / (CoordinateUtilities3D.norm(v1) * CoordinateUtilities3D.norm(v2)));
        return 180.0 * a / Math.PI;
    }

    public static double angleRad(double[] p1, double[] p2, double[] p3) {
        double[] v1 = new double[]{p1[0] - p2[0], p1[1] - p2[1], p1[2] - p2[2]};
        double[] v2 = new double[]{p3[0] - p2[0], p3[1] - p2[1], p3[2] - p2[2]};
        double result = CoordinateUtilities3D.angleRad(v1, v2);
        return result;
    }

    public static double angleDeg(double[] p1, double[] p2, double[] p3) {
        double[] v1 = new double[]{p1[0] - p2[0], p1[1] - p2[1], p1[2] - p2[2]};
        double[] v2 = new double[]{p3[0] - p2[0], p3[1] - p2[1], p3[2] - p2[2]};
        double result = CoordinateUtilities3D.angleDeg(v1, v2);
        return result;
    }

    public static double torsionRad(double[] p1, double[] p2, double[] p3, double[] p4) {
        double[] v21 = CoordinateUtilities3D.subtract(p1, p2);
        double[] v23 = CoordinateUtilities3D.subtract(p3, p2);
        double[] cv1 = CoordinateUtilities3D.crossprod(v21, v23);
        double[] v32 = CoordinateUtilities3D.subtract(p2, p3);
        double[] v34 = CoordinateUtilities3D.subtract(p4, p3);
        double[] cv2 = CoordinateUtilities3D.crossprod(v32, v34);
        double angle = CoordinateUtilities3D.angleRad(cv1, cv2);
        if (CoordinateUtilities3D.dotprod(v34, cv1) > 0.0) {
            angle = -angle;
        }
        return angle;
    }

    public static double torsionDeg(double[] p1, double[] p2, double[] p3, double[] p4) {
        return 180.0 * CoordinateUtilities3D.torsionRad(p1, p2, p3, p4) / Math.PI;
    }

    public static double torsionDeg(double[][] crd, int i1, int i2, int i3, int i4) {
        return CoordinateUtilities3D.torsionDeg(crd[i1], crd[i2], crd[i3], crd[i4]);
    }

    public static double torsionDeg(double[][] crd, int[] indexes) {
        return CoordinateUtilities3D.torsionDeg(crd[indexes[0]], crd[indexes[1]], crd[indexes[2]], crd[indexes[3]]);
    }

    public static double[] torsionsDeg(double[][] crd, int[][] indexes) {
        double[] res = new double[indexes.length];
        int i = 0;
        while (i < res.length) {
            res[i] = CoordinateUtilities3D.torsionDeg(crd[indexes[i][0]], crd[indexes[i][1]], crd[indexes[i][2]], crd[indexes[i][3]]);
            ++i;
        }
        return res;
    }

    public static double cosineTheorem(double d12, double d23, double theta123) {
        return d12 * d12 + d23 * d23 - 2.0 * d12 * d23 * Math.cos(theta123);
    }

    public static double dist14(double d12, double d23, double d34, double theta123, double theta234, double phi) {
        double alpha123 = Math.PI - theta123;
        double alpha234 = Math.PI - theta234;
        double a1 = Math.cos(alpha123) * d12;
        double a2 = Math.sin(alpha123) * d12;
        double b1 = Math.cos(alpha234) * d34;
        double b2 = Math.sin(alpha234) * d34;
        double c = a1 + d23 + b1;
        double e_sq = CoordinateUtilities3D.cosineTheorem(a2, b2, phi);
        return Math.sqrt(c * c + e_sq);
    }

    public static double norm(double[] v) {
        return Math.sqrt(CoordinateUtilities3D.dotprod(v, v));
    }

    public static double[] normalize(double[] v) {
        double[] v0 = new double[3];
        double n = CoordinateUtilities3D.norm(v);
        v0[0] = v[0] / n;
        v0[1] = v[1] / n;
        v0[2] = v[2] / n;
        return v0;
    }

    public static void translate(double[][] crds, double x, double y, double z) {
        int i = 0;
        while (i < crds.length) {
            crds[i][0] = crds[i][0] + x;
            crds[i][1] = crds[i][1] + y;
            crds[i][2] = crds[i][2] + z;
            ++i;
        }
    }

    public static void translate(double[][] crds, int[] select, double x, double y, double z) {
        int i = 0;
        while (i < select.length) {
            crds[select[i]][0] = crds[select[i]][0] + x;
            crds[select[i]][1] = crds[select[i]][1] + y;
            crds[select[i]][2] = crds[select[i]][2] + z;
            ++i;
        }
    }

    public static double[][] rotationMatrix(double[] r, double psi) {
        double[] r0 = CoordinateUtilities3D.normalize(r);
        double[][] Mr = new double[3][3];
        double cospsi = Math.cos(psi);
        double sinpsi = Math.sin(psi);
        double one_cospsi = 1.0 - cospsi;
        Mr[0][0] = r0[0] * r0[0] * one_cospsi + cospsi;
        Mr[0][1] = r0[0] * r0[1] * one_cospsi - r0[2] * sinpsi;
        Mr[0][2] = r0[0] * r0[2] * one_cospsi + r0[1] * sinpsi;
        Mr[1][0] = r0[0] * r0[1] * one_cospsi + r0[2] * sinpsi;
        Mr[1][1] = r0[1] * r0[1] * one_cospsi + cospsi;
        Mr[1][2] = r0[1] * r0[2] * one_cospsi - r0[0] * sinpsi;
        Mr[2][0] = r0[0] * r0[2] * one_cospsi - r0[1] * sinpsi;
        Mr[2][1] = r0[1] * r0[2] * one_cospsi + r0[0] * sinpsi;
        Mr[2][2] = r0[2] * r0[2] * one_cospsi + cospsi;
        return Mr;
    }

    public static double[][] matrixMultiply(double[][] M1, double[][] M2) {
        double[][] M = new double[3][3];
        M[0][0] = M1[0][0] * M2[0][0] + M1[0][1] * M2[1][0] + M1[0][2] * M2[2][0];
        M[0][1] = M1[0][0] * M2[0][1] + M1[0][1] * M2[1][1] + M1[0][2] * M2[2][1];
        M[0][2] = M1[0][0] * M2[0][2] + M1[0][1] * M2[1][2] + M1[0][2] * M2[2][2];
        M[1][0] = M1[1][0] * M2[0][0] + M1[1][1] * M2[1][0] + M1[1][2] * M2[2][0];
        M[1][1] = M1[1][0] * M2[0][1] + M1[1][1] * M2[1][1] + M1[1][2] * M2[2][1];
        M[1][2] = M1[1][0] * M2[0][2] + M1[1][1] * M2[1][2] + M1[1][2] * M2[2][2];
        M[2][0] = M1[2][0] * M2[0][0] + M1[2][1] * M2[1][0] + M1[2][2] * M2[2][0];
        M[2][1] = M1[2][0] * M2[0][1] + M1[2][1] * M2[1][1] + M1[2][2] * M2[2][1];
        M[2][2] = M1[2][0] * M2[0][2] + M1[2][1] * M2[1][2] + M1[2][2] * M2[2][2];
        return M;
    }

    public static double det(double[][] M) {
        double res = M[0][0] * M[1][1] * M[2][2] + M[0][1] * M[1][2] * M[2][0] + M[0][2] * M[1][0] * M[2][1] - M[0][2] * M[1][1] * M[2][0] - M[0][1] * M[1][0] * M[2][2] - M[0][0] * M[1][2] * M[2][1];
        return res;
    }

    public static void applyMatrix(double[][] crds, double[][] M, int[] selection) {
        int i = 0;
        while (i < selection.length) {
            crds[selection[i]][0] = crds[selection[i]][0] * M[0][0] + crds[selection[i]][1] * M[0][1] + crds[selection[i]][2] * M[0][2];
            crds[selection[i]][1] = crds[selection[i]][0] * M[1][0] + crds[selection[i]][1] * M[1][1] + crds[selection[i]][2] * M[1][2];
            crds[selection[i]][2] = crds[selection[i]][0] * M[2][0] + crds[selection[i]][1] * M[2][1] + crds[selection[i]][2] * M[2][2];
            ++i;
        }
    }

    public static void rotatePointsRad(double[][] crds, int[] movingAtoms, int nMoving, double[] r1, double[] r2, double psiRad) {
        double[][] Mr = CoordinateUtilities3D.rotationMatrix(CoordinateUtilities3D.subtract(r2, r1), psiRad);
        int i = 0;
        while (i < nMoving) {
            int a = movingAtoms[i];
            crds[a][0] = crds[a][0] - r2[0];
            crds[a][1] = crds[a][1] - r2[1];
            crds[a][2] = crds[a][2] - r2[2];
            double rx = Mr[0][0] * crds[a][0] + Mr[0][1] * crds[a][1] + Mr[0][2] * crds[a][2];
            double ry = Mr[1][0] * crds[a][0] + Mr[1][1] * crds[a][1] + Mr[1][2] * crds[a][2];
            double rz = Mr[2][0] * crds[a][0] + Mr[2][1] * crds[a][1] + Mr[2][2] * crds[a][2];
            crds[a][0] = rx + r2[0];
            crds[a][1] = ry + r2[1];
            crds[a][2] = rz + r2[2];
            ++i;
        }
    }

    public static void rotatePointsRad(double[][] crds, int[] movingAtoms, double[] r1, double[] r2, double psiRad) {
        CoordinateUtilities3D.rotatePointsRad(crds, movingAtoms, movingAtoms.length, r1, r2, psiRad);
    }

    public static void rotateRad(double[] crd, double[] r1, double[] r2, double psiRad) {
        double[][] crds = new double[][]{crd};
        int[] movingAtoms = new int[1];
        CoordinateUtilities3D.rotatePointsRad(crds, movingAtoms, 1, r1, r2, psiRad);
    }

    public static void rotateDeg(double[] crd, double[] r1, double[] r2, double psiDeg) {
        CoordinateUtilities3D.rotateRad(crd, r1, r2, Math.PI * psiDeg / 180.0);
    }

    public static void rotatePointsDeg(double[][] crds, int[] movingAtoms, int nMoving, double[] r1, double[] r2, double psiDeg) {
        CoordinateUtilities3D.rotatePointsRad(crds, movingAtoms, nMoving, r1, r2, Math.PI * psiDeg / 180.0);
    }

    public static void rotatePointsDeg(double[][] crds, int[] movingAtoms, double[] r1, double[] r2, double psiDeg) {
        CoordinateUtilities3D.rotatePointsRad(crds, movingAtoms, movingAtoms.length, r1, r2, Math.PI * psiDeg / 180.0);
    }

    public static boolean triangulate(double[] p1, double[] p2, double[] p3, double d1, double d2, double d3, double[] s1, double[] s2) {
        double[] v12 = CoordinateUtilities3D.subtract(p2, p1);
        double d12sq = CoordinateUtilities3D.dotprod(v12, v12);
        double d12 = Math.sqrt(d12sq);
        double[] v120 = CoordinateUtilities3D.stretch(1.0 / d12, v12);
        double[] v13 = CoordinateUtilities3D.subtract(p3, p1);
        double d13sq = CoordinateUtilities3D.dotprod(v13, v13);
        double d13 = Math.sqrt(d13sq);
        double[] v23 = CoordinateUtilities3D.subtract(p3, p2);
        double d23sq = CoordinateUtilities3D.dotprod(v23, v23);
        double d23 = Math.sqrt(d23sq);
        double arg = (-d2 * d2 + d1 * d1 + d12sq) / (2.0 * d1 * d12);
        if (arg < -1.0 || arg > 1.0) {
            return false;
        }
        double dF = d1 * arg;
        double r = d1 * Math.sin(MathTools.acos(arg));
        double[] pF = CoordinateUtilities3D.addweighted(1.0, p1, dF, v120);
        double dF_2 = (-d13sq + d12sq + d23sq) / (2.0 * d12);
        double[] pF_2 = CoordinateUtilities3D.addweighted(1.0, p2, -dF_2, v120);
        double[] vi = CoordinateUtilities3D.subtract(p3, pF_2);
        double[] vi0 = CoordinateUtilities3D.normalize(vi);
        double[] vFF = CoordinateUtilities3D.subtract(pF_2, pF);
        double dFFsq = CoordinateUtilities3D.dotprod(vFF, vFF);
        arg = d3 * d3 - dFFsq;
        if (arg < 0.0) {
            return false;
        }
        double dp3flat = Math.sqrt(arg);
        double[] vF3 = CoordinateUtilities3D.subtract(p3, pF);
        double dF3 = CoordinateUtilities3D.norm(vF3);
        double beta = CoordinateUtilities3D.angleRad(vi, vF3);
        double d3v12 = Math.cos(beta) * dF3;
        arg = (-dp3flat * dp3flat + r * r + d3v12 * d3v12) / (2.0 * r * d3v12);
        if (arg < -1.0 || arg > 1.0) {
            return false;
        }
        double dF_3 = r * arg;
        double r_3 = r * Math.sin(MathTools.acos(arg));
        double[] pF_3 = CoordinateUtilities3D.addweighted(1.0, pF, dF_3, vi0);
        double[] vN = CoordinateUtilities3D.crossprod(v12, v13);
        double[] vN0 = CoordinateUtilities3D.normalize(vN);
        s1[0] = pF_3[0] + r_3 * vN0[0];
        s1[1] = pF_3[1] + r_3 * vN0[1];
        s1[2] = pF_3[2] + r_3 * vN0[2];
        s2[0] = pF_3[0] - r_3 * vN0[0];
        s2[1] = pF_3[1] - r_3 * vN0[1];
        s2[2] = pF_3[2] - r_3 * vN0[2];
        return true;
    }

    public static int[] equalPoints(double[][] arr1, double[][] arr2, double tol) {
        if (arr1.length != arr2.length) {
            throw new IllegalArgumentException("incompatible arrays");
        }
        int[] ep = new int[arr1.length];
        int k = 0;
        int i = 0;
        while (i < arr1.length) {
            if (CoordinateUtilities3D.distance(arr1[i], arr2[i]) <= tol) {
                ep[k++] = i;
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(ep, 0, k);
    }

    public static int closestPoint(double[] p, double[][] points, int nPoints) {
        int si = 0;
        int i = 0;
        double[] d = CoordinateUtilities3D.subtract(p, points[0]);
        double ssd = CoordinateUtilities3D.dotprod(d, d);
        i = 1;
        while (i < nPoints) {
            d = CoordinateUtilities3D.subtract(p, points[i]);
            double sd = CoordinateUtilities3D.dotprod(d, d);
            if (sd < ssd) {
                ssd = sd;
                si = i;
            }
            ++i;
        }
        return si;
    }

    public static double[] bounds(double[][] crds) {
        double[] b = new double[]{crds[0][0], crds[0][0], crds[0][1], crds[0][1], crds[0][2], crds[0][2]};
        int i = 1;
        while (i < crds.length) {
            if (crds[i][0] < b[0]) {
                b[0] = crds[i][0];
            }
            if (crds[i][0] > b[1]) {
                b[1] = crds[i][0];
            }
            if (crds[i][1] < b[2]) {
                b[2] = crds[i][1];
            }
            if (crds[i][1] > b[3]) {
                b[3] = crds[i][1];
            }
            if (crds[i][2] < b[4]) {
                b[4] = crds[i][2];
            }
            if (crds[i][2] > b[5]) {
                b[5] = crds[i][2];
            }
            ++i;
        }
        return b;
    }

    public static double pointLineDistance(double[] p, double[] a, double[] va) {
        double h = CoordinateUtilities3D.dotprod(va, CoordinateUtilities3D.subtract(p, a)) / CoordinateUtilities3D.dotprod(va, va);
        double[] L = CoordinateUtilities3D.addweighted(1.0, a, h, va);
        return CoordinateUtilities3D.distance(L, p);
    }

    public static double pointSegmentDistance(double[] p, double[] a, double[] va) {
        double h = CoordinateUtilities3D.dotprod(va, CoordinateUtilities3D.subtract(p, a)) / CoordinateUtilities3D.dotprod(va, va);
        h = Math.min(h, 1.0);
        h = Math.max(h, 0.0);
        double[] L = CoordinateUtilities3D.addweighted(1.0, a, h, va);
        return CoordinateUtilities3D.distance(L, p);
    }

    private static int lineOrientation(double[] a1, double[] a2, double[] b1, double[] b2) {
        double[] a12 = CoordinateUtilities3D.subtract(a2, a1);
        double[] b12 = CoordinateUtilities3D.subtract(b2, b1);
        double[] a1b1 = CoordinateUtilities3D.subtract(b1, a1);
        double[] n = CoordinateUtilities3D.crossprod(a12, b12);
        return MathTools.sign(CoordinateUtilities3D.dotprod(n, a1b1));
    }

    public static void transformRigid(double[][] buildCrds, double[][] referenceCrds, int i1, int i2, int i3, int[] sel) {
        double arot2;
        if (i1 < 0 || i2 < 0 || i3 < 0) {
            throw new RuntimeException("Trying to build transform nonexisting pos.");
        }
        int i = 0;
        while (i < sel.length) {
            CoordinateUtilities3D.copy(referenceCrds[sel[i]], buildCrds[sel[i]]);
            ++i;
        }
        double[] p10 = buildCrds[i1];
        double[] p1r = referenceCrds[i1];
        double[] p20 = buildCrds[i2];
        double[] p2r = referenceCrds[i2];
        double[] p30 = buildCrds[i3];
        double[] p3r = referenceCrds[i3];
        double[] p1copy = PrimitiveDoubleTools.copy(p1r);
        double[] t = CoordinateUtilities3D.subtract(p20, p2r);
        CoordinateUtilities3D.translate(buildCrds, sel, t[0], t[1], t[2]);
        p1copy = CoordinateUtilities3D.add(p1copy, t);
        double[] n0 = CoordinateUtilities3D.crossprod(CoordinateUtilities3D.subtract(p20, p10), CoordinateUtilities3D.subtract(p20, p30));
        double[] vCaNr = CoordinateUtilities3D.subtract(p2r, p3r);
        double[] nr = CoordinateUtilities3D.crossprod(CoordinateUtilities3D.subtract(p2r, p1r), vCaNr);
        double[] vrot1 = CoordinateUtilities3D.crossprod(nr, n0);
        double[] virt1 = CoordinateUtilities3D.add(p20, vrot1);
        double arot1 = CoordinateUtilities3D.angleRad(nr, n0);
        if (arot1 > 0.0) {
            CoordinateUtilities3D.rotatePointsRad(buildCrds, sel, p20, virt1, arot1);
            CoordinateUtilities3D.rotateRad(p1copy, p20, CoordinateUtilities3D.add(p20, vrot1), arot1);
        }
        if ((arot2 = CoordinateUtilities3D.angleRad(CoordinateUtilities3D.subtract(p1copy, p20), CoordinateUtilities3D.subtract(p10, p20))) > 0.0) {
            double[] n2 = CoordinateUtilities3D.crossprod(CoordinateUtilities3D.subtract(p1copy, p20), CoordinateUtilities3D.subtract(p10, p20));
            double[] virt2 = CoordinateUtilities3D.add(p20, n2);
            CoordinateUtilities3D.rotatePointsRad(buildCrds, sel, p20, virt2, arot2);
            CoordinateUtilities3D.rotateRad(p1copy, p20, virt2, arot2);
        }
    }

    public static void DEBUG_printCrd(double[] crd) {
        System.out.println(String.valueOf(crd[0]) + ", " + crd[1] + ", " + crd[2]);
    }

    public static void DEBUG_printCrdMatrix(double[][] crd) {
        int i = 0;
        while (i < crd.length) {
            System.out.print(crd[i][0]);
            System.out.print(crd[i][1]);
            System.out.println(crd[i][2]);
            ++i;
        }
    }

    public static void timer(String msg) {
        if (msg == null) {
            t = System.currentTimeMillis();
        } else {
            System.out.println(String.valueOf(msg) + "\t" + (double)(System.currentTimeMillis() - t) / 1000.0);
        }
    }

    public static void main(String[] args) {
        double[][] V2;
        double[][] V1;
        Arguments arg;
        if (args.length == 0) {
            System.out.println("usage: LinalgTools [mode]\n          -subspaceOverlap <V1> <V2>\n          -superspaceOverlap <V1> <V2>\n          -largestEVanalysis (-ibin <matrix-bin> | -itxt <matrix-bin>) (-o <evecOut> <evalOut>)\n          -powerMethod <matrix>");
            System.out.println("          -eigenvalues <matrix>");
            System.exit(0);
        }
        if ((arg = new Arguments(args)).hasCommand("subspaceOverlap")) {
            V1 = PrimitiveDoubleTools.loadMatrix(arg.getArgument("subspaceOverlap", 0));
            V2 = PrimitiveDoubleTools.loadMatrix(arg.getArgument("subspaceOverlap", 1));
            System.out.println(CoordinateUtilities3D.subspaceOverlap(V1, V2));
        }
        if (arg.hasCommand("superspaceOverlap")) {
            V1 = PrimitiveDoubleTools.loadMatrix(arg.getArgument("superspaceOverlap", 0));
            V2 = PrimitiveDoubleTools.loadMatrix(arg.getArgument("superspaceOverlap", 1));
            System.out.println(CoordinateUtilities3D.superspaceOverlap(V1, V2));
        }
    }
}

