/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.doubles;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleElement;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.doubles.IDoubleList;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.doubles.DenseDoubleArray;
import stallone.doubles.DoubleIO;
import stallone.doubles.QuickSortDouble;

public class DoubleUtilities {
    private static DoubleIO io;

    public void set(IDoubleArray arr, double[] values) {
        if (!(arr instanceof DenseDoubleArray)) {
            throw new UnsupportedOperationException("Mass value setting not (yet) supported for the given matrix type.");
        }
        ((DenseDoubleArray)arr).set(values);
    }

    public void fill(IDoubleArray arr, double d) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, d);
            ++i;
        }
    }

    public void copyInto(IDoubleArray source, int start1, int end1, IDoubleArray target, int start2) {
        if (start1 < 0 || end1 >= source.size() || start1 >= end1 || start2 < 0 || start2 + (end1 - start1) >= target.size()) {
            throw new IllegalArgumentException("Attempting array copy with illegal indexes: from " + start1 + " - " + end1 + " / " + source.size() + ". To " + start2 + " - " + start2 + (end1 - start1) + " / " + target.size());
        }
        int i = start1;
        while (i < end1) {
            target.set(start2 + i, source.get(i));
            ++i;
        }
    }

    public void mirror(IDoubleArray arr) {
        int n = arr.size();
        int nhalf = n / 2;
        int i = 0;
        while (i < nhalf) {
            double h = arr.get(i);
            arr.set(i, arr.get(n - 1 - i));
            arr.set(n - 1 - i, h);
            ++i;
        }
    }

    public void exchange(IDoubleArray arr, int i, int j) {
        double h = arr.get(i);
        arr.set(i, arr.get(j));
        arr.set(j, h);
    }

    public double sum(IDoubleArray arr) {
        double res = 0.0;
        int i = 0;
        while (i < arr.size()) {
            res += arr.get(i);
            ++i;
        }
        return res;
    }

    public int count(IDoubleArray arr, double val) {
        int c = 0;
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) == val) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public boolean equal(IDoubleArray arr1, IDoubleArray arr2, double tol) {
        if (arr1.size() != arr2.size()) {
            return false;
        }
        int i = 0;
        while (i < arr1.size()) {
            double v2;
            double v1 = arr1.get(i);
            if (v1 != (v2 = arr2.get(i)) && Math.abs(v1 - v2) > tol) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equal(IDoubleArray arr1, IDoubleArray arr2) {
        return this.equal(arr1, arr2, 0.0);
    }

    public int maxIndex(IDoubleArray arr) {
        double m = Double.NEGATIVE_INFINITY;
        int im = 0;
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) > m) {
                m = arr.get(i);
                im = i;
            }
            ++i;
        }
        return im;
    }

    public double max(IDoubleArray arr) {
        return arr.get(this.maxIndex(arr));
    }

    public int minIndex(IDoubleArray arr) {
        double m = Double.POSITIVE_INFINITY;
        int im = 0;
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) < m) {
                m = arr.get(i);
                im = i;
            }
            ++i;
        }
        return im;
    }

    public double min(IDoubleArray arr) {
        return arr.get(this.minIndex(arr));
    }

    public <T extends IDoubleArray> T subToNew(T arr, int start, int end) {
        IDoubleArray res = arr.create(end - start);
        int i = start;
        while (i < end) {
            if (res instanceof IDoubleList) {
                ((IDoubleList)res).append(arr.get(i));
            } else {
                res.set(i - start, arr.get(i));
            }
            ++i;
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T subToNew(T arr, IIntArray indexes) {
        IDoubleArray res = arr.create(indexes.size());
        int i = 0;
        while (i < indexes.size()) {
            if (res instanceof IDoubleList) {
                ((IDoubleList)res).append(arr.get(indexes.get(i)));
            } else {
                res.set(i, arr.get(indexes.get(i)));
            }
            ++i;
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T insertToNew(T arr, int index, double v) {
        IDoubleArray res = arr.create(arr.size() + 1);
        int j = 0;
        int i = 0;
        while (i < index) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        res.set(j, v);
        ++j;
        i = index;
        while (i < arr.size()) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T mergeToNew(Collection<T> a) {
        int size = 0;
        IDoubleArray template = null;
        for (IDoubleArray c : a) {
            if (template == null) {
                template = c;
            }
            size += c.size();
        }
        IDoubleArray res = template.create(size);
        int j = 0;
        for (IDoubleArray c : a) {
            int i = 0;
            while (i < c.size()) {
                res.set(j, c.get(i));
                ++j;
                ++i;
            }
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T mergeToNew(T a1, T a2) {
        IDoubleArray res = a1.create(a1.size() + a2.size());
        int j = 0;
        int i = 0;
        while (i < a1.size()) {
            res.set(j, a1.get(i));
            ++j;
            ++i;
        }
        i = 0;
        while (i < a2.size()) {
            res.set(j, a2.get(i));
            ++j;
            ++i;
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T mergeToNew(T a1, double a2) {
        IDoubleArray res = a1.create(a1.size() + 1);
        int i = 0;
        while (i < a1.size()) {
            res.set(i, a1.get(i));
            ++i;
        }
        res.set(res.size() - 1, a2);
        return (T)res;
    }

    public boolean isSorted(IDoubleArray arr) {
        int i = 0;
        while (i < arr.size() - 1) {
            if (arr.get(i) > arr.get(i + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void sort(IDoubleArray arr) {
        QuickSortDouble qs = new QuickSortDouble();
        qs.setData(arr, arr);
        qs.sort();
    }

    public IIntArray sortedIndexes(IDoubleArray arr) {
        QuickSortDouble qs = new QuickSortDouble();
        qs.setData(arr, arr.copy());
        qs.sort();
        return qs.getSortedIndexes();
    }

    public <T extends IDoubleArray> T cleanToNew(T arr) {
        IDoubleArray uncleaned = arr.copy();
        if (uncleaned.size() == 0) {
            return (T)uncleaned;
        }
        Doubles.util.sort(uncleaned);
        IIntList Iclean = Ints.create.list(uncleaned.size());
        Iclean.set(0, 0);
        int i = 1;
        while (i < uncleaned.size()) {
            if (uncleaned.get(i) != uncleaned.get(i - 1)) {
                Iclean.append(i);
            }
            ++i;
        }
        return (T)this.subToNew(uncleaned, Iclean);
    }

    public IIntArray smallestIndexes(IDoubleArray arr, int n) {
        IIntArray indexes = this.sortedIndexes(arr);
        return Ints.util.subToNew(indexes, 0, n);
    }

    public <T extends IDoubleArray> T smallest(T arr, int n) {
        return this.subToNew(arr, this.smallestIndexes(arr, n));
    }

    public IIntArray largestIndexes(IDoubleArray arr, int n) {
        IIntArray indexes = this.sortedIndexes(arr);
        IIntArray largest = Ints.util.subToNew(indexes, indexes.size() - n, indexes.size());
        Ints.util.mirror(largest);
        return largest;
    }

    public <T extends IDoubleArray> T largest(T arr, int n) {
        return this.subToNew(arr, this.largestIndexes(arr, n));
    }

    public <T extends IDoubleArray> T smallValues(T arr, double maxValue) {
        return this.subToNew(arr, this.smallValueIndexes(arr, maxValue));
    }

    public IIntArray smallValueIndexes(IDoubleArray arr, double maxValue) {
        IIntList res = Ints.create.list(0);
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) <= maxValue) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public <T extends IDoubleArray> T largeValues(T arr, double minValue) {
        return this.subToNew(arr, this.largeValueIndexes(arr, minValue));
    }

    public IIntArray largeValueIndexes(IDoubleArray arr, double minValue) {
        IIntList res = Ints.create.list(0);
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) >= minValue) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public <T extends IDoubleArray> T within(T arr, double minVal, double maxVal) {
        return this.subToNew(arr, this.withinIndexes(arr, minVal, maxVal));
    }

    public IIntArray withinIndexes(IDoubleArray arr, double minVal, double maxVal) {
        IIntList res = Ints.create.list(arr.size() / 2);
        int i = 0;
        while (i < arr.size()) {
            if (minVal <= arr.get(i) && arr.get(i) < maxVal) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public int findForward(IDoubleArray arr, double val, int from) {
        int i = from;
        while ((double)i < arr.get(i)) {
            if (arr.get(i) == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findForward(IDoubleArray arr, double val) {
        return this.findForward(arr, val, 0);
    }

    public int findBackwards(IDoubleArray arr, double val, int from) {
        int i = from;
        while (i >= 0) {
            if (arr.get(i) == val) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int findBackwards(IDoubleArray arr, double val) {
        return this.findBackwards(arr, val, 0);
    }

    private void findAll(IDoubleArray arr, double val, IIntList to) {
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) == val) {
                to.append(i);
            }
            ++i;
        }
    }

    public IIntList findAll(IDoubleArray arr, double val) {
        IIntList res = Ints.create.list(0);
        this.findAll(arr, val, res);
        return res;
    }

    public IIntList findAll(IDoubleArray arr, IDoubleArray vals) {
        IIntList res = Ints.create.list(0);
        int i = 0;
        while (i < vals.size()) {
            this.findAll(arr, vals.get(i), res);
            ++i;
        }
        return res;
    }

    public boolean contains(IDoubleArray arr, double val) {
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAny(IDoubleArray arr, IDoubleArray val) {
        int i = 0;
        while (i < val.size()) {
            if (this.contains(arr, val.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAll(IDoubleArray arr, IDoubleArray val) {
        int i = 0;
        while (i < val.size()) {
            if (!this.contains(arr, val.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int findClosest(IDoubleArray arr, double num) {
        int i = this.locateSorted(arr, num);
        if (i == 0) {
            return i;
        }
        if (i == arr.size()) {
            return i - 1;
        }
        if (Math.abs(arr.get(i - 1) - num) < Math.abs(arr.get(i) - num)) {
            return i - 1;
        }
        return i;
    }

    public int locateSorted(IDoubleArray arr, double num) {
        int l = 0;
        int m = arr.size() / 2;
        int r = arr.size();
        boolean found = false;
        while (!found) {
            if (num < arr.get(m)) {
                r = m;
                m = (r + l) / 2;
            } else if (num > arr.get(m)) {
                l = m;
                m = (r + l) / 2;
            } else {
                found = true;
            }
            if (m != l && m != r) continue;
            found = true;
        }
        found = false;
        while (!found) {
            if (m == 0) {
                found = true;
                continue;
            }
            if (arr.get(m - 1) != arr.get(m)) {
                found = true;
                continue;
            }
            --m;
        }
        if (num > arr.get(m)) {
            ++m;
        }
        return m;
    }

    public void insertSorted(IDoubleList arr, double num) {
        int i = this.locateSorted(arr, num);
        arr.insert(i, num);
    }

    public int insertSortedFixed(IDoubleArray arr, double num) {
        if (num >= arr.get(arr.size() - 1)) {
            return -1;
        }
        int i = arr.size() - 1;
        while (i >= 1) {
            if (!(arr.get(i - 1) >= num)) break;
            arr.set(i, arr.get(i - 1));
            --i;
        }
        arr.set(i, num);
        return i;
    }

    public int findSorted(IDoubleArray arr, double num) {
        int i = this.locateSorted(arr, num);
        if (arr.get(i) == num) {
            return i;
        }
        return -1;
    }

    public <T extends IDoubleArray> T intersectionToNew(T arr1, T arr2) {
        T arr1c = this.cleanToNew(arr1);
        T arr2c = this.cleanToNew(arr2);
        IDoubleList res = Doubles.create.list(Math.min(arr1c.size(), arr2c.size()));
        int i = 0;
        while (i < arr1c.size()) {
            int j = 0;
            while (j < arr2c.size()) {
                if (arr1c.get(i) == arr2c.get(j)) {
                    res.append(arr1c.get(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        IDoubleArray resfinal = arr1.create(res.size());
        this.copyInto(res, 0, res.size(), resfinal, 0);
        return (T)resfinal;
    }

    public <T extends IDoubleArray> T unionToNew(T arr1, T arr2) {
        return this.cleanToNew(this.mergeToNew(arr1, arr2));
    }

    public <T extends IDoubleArray> T removeIndexToNew(T arr, int index) {
        IDoubleArray res = arr.create(arr.size() - 1);
        int j = 0;
        int i = 0;
        while (i < index) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        i = index + 1;
        while (i < arr.size()) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T removeIndexToNew(T arr, IIntArray index) {
        if (arr.size() == 0) {
            return arr;
        }
        IIntArray keep = Ints.create.arrayRange(arr.size());
        keep = Ints.util.removeValueToNew(keep, index);
        return this.subToNew(arr, keep);
    }

    public <T extends IDoubleArray> T removeValueToNew(T arr1, IDoubleArray vals) {
        IIntList indexes = this.findAll(arr1, vals);
        return this.removeIndexToNew(arr1, indexes);
    }

    public <T extends IDoubleArray> T removeValueToNew(T arr1, int a2) {
        return this.removeValueToNew(arr1, Doubles.create.arrayFrom(a2));
    }

    public String toString(IDoubleArray arr) {
        return DoubleIO.toString(arr);
    }

    public void print(IDoubleArray arr, PrintStream out) {
        DoubleIO.print(arr, out);
    }

    public void print(IDoubleArray arr, String del) {
        DoubleIO.print(arr, del);
    }

    public String toString(IDoubleArray arr, String del) {
        return DoubleIO.toString(arr, del);
    }

    public void print(IDoubleArray arr) {
        DoubleIO.print(arr);
    }

    public String toString(IDoubleArray arr, String del, int predig, int postdig) {
        return DoubleIO.toString(arr, del, predig, postdig);
    }

    public void print(IDoubleArray arr, String del, int predig, int postdig) {
        DoubleIO.print(arr, del, predig, postdig);
    }

    public double sumRow(IDoubleArray arr, int row) {
        double res = 0.0;
        int i = 0;
        while (i < arr.columns()) {
            res += arr.get(row, i);
            ++i;
        }
        return res;
    }

    public double sumCol(IDoubleArray arr, int col) {
        double res = 0.0;
        int i = 0;
        while (i < arr.rows()) {
            res += arr.get(i, col);
            ++i;
        }
        return res;
    }

    public void transpose(IDoubleArray tab) {
        int ncols;
        int nrows = tab.rows();
        if (nrows != (ncols = tab.columns())) {
            throw new IllegalArgumentException("Cannot transpose in place if nrows differs from ncolumns. Use createTranspose in the factory");
        }
        int i = 0;
        while (i < nrows) {
            int j = i + 1;
            while (j < ncols) {
                double h = tab.get(i, j);
                tab.set(i, j, tab.get(j, i));
                tab.set(j, i, h);
                ++j;
            }
            ++i;
        }
    }

    public void copyInto(IDoubleArray aFrom, int rowA0, int colA0, int rowA1, int colA1, IDoubleArray bTo, int rowB0, int colB0) {
        if (rowA0 < 0 || colA0 < 0 || bTo.rows() < rowB0 + (rowA1 - rowA0) || bTo.columns() < colB0 + (colA1 - colA0)) {
            throw new IllegalArgumentException("Trying to copy array over boundaries of target");
        }
        int i = rowA0;
        while (i < rowA1) {
            int j = colA0;
            while (j < colA1) {
                bTo.set(i + rowA0, j + colA0, aFrom.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void copyInto(IDoubleArray aFrom, IDoubleArray bTo, int rowB0, int colB0) {
        this.copyInto(aFrom, 0, 0, aFrom.rows(), aFrom.columns(), bTo, rowB0, colB0);
    }

    public IDoubleArray merge(IDoubleArray a1, IDoubleArray a2) {
        if (a1.columns() != a2.columns()) {
            throw new IllegalArgumentException("Trying to merge incompatible tables");
        }
        IDoubleArray res = a1.create(a1.rows() + a2.rows(), a1.columns());
        this.copyInto(a1, res, 0, 0);
        this.copyInto(a2, res, a1.rows(), 0);
        return res;
    }

    public IDoubleArray mergeColumns(IDoubleArray a1, IDoubleArray a2) {
        if (a1.rows() != a2.rows()) {
            throw new IllegalArgumentException("Trying to merge incompatible tables");
        }
        IDoubleArray res = a1.create(a1.rows(), a1.columns() + a2.columns());
        this.copyInto(a1, res, 0, 0);
        this.copyInto(a2, res, 0, a1.columns());
        return res;
    }

    public <T extends IDoubleArray> T insertRowToNew(T a, int rowIndex, IDoubleArray r) {
        if (a.columns() != r.size()) {
            throw new IllegalArgumentException("Trying to merge incompatible tables");
        }
        IDoubleArray res = a.create(a.rows() + 1, a.columns());
        this.copyInto(a, 0, 0, rowIndex, a.columns(), res, 0, 0);
        int i = 0;
        while (i < r.size()) {
            res.set(rowIndex, i, r.get(i));
            ++i;
        }
        this.copyInto(a, rowIndex, 0, a.rows(), a.columns(), res, rowIndex + 1, 0);
        return (T)res;
    }

    public <T extends IDoubleArray> T subTable(T a1, IIntArray rowIndexes, IIntArray colIndexes) {
        IDoubleArray res = a1.create(rowIndexes.size(), colIndexes.size());
        int i = 0;
        while (i < rowIndexes.size()) {
            int j = 0;
            while (j < colIndexes.size()) {
                res.set(i, j, a1.get(rowIndexes.get(i), colIndexes.get(j)));
                ++j;
            }
            ++i;
        }
        return (T)res;
    }

    public <T extends IDoubleArray> T subRows(T a1, IIntArray rowIndexes) {
        return this.subTable(a1, rowIndexes, Ints.create.arrayRange(a1.columns()));
    }

    public <T extends IDoubleArray> T subColumns(T a1, IIntArray colIndexes) {
        return this.subTable(a1, Ints.create.arrayRange(a1.rows()), colIndexes);
    }

    public int findRowForward(IDoubleArray arr, IDoubleArray val, int from) {
        int i = from;
        while ((double)i < arr.get(i)) {
            if (this.equal(arr.viewRow(i), val)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findRowForward(IDoubleArray arr, IDoubleArray val) {
        return this.findRowForward(arr, val, 0);
    }

    public int findBackwards(IDoubleArray arr, IDoubleArray val, int from) {
        int i = from;
        while (i >= 0) {
            if (this.equal(arr.viewRow(i), val)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int findBackwards(IDoubleArray arr, IDoubleArray val) {
        return this.findBackwards(arr, val, 0);
    }

    public IIntArray findAllRows(IDoubleArray arr, IDoubleArray val) {
        IIntList res = Ints.create.list(0);
        int i = 0;
        while (i < arr.size()) {
            if (this.equal(arr.viewRow(i), val)) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public int countRows(IDoubleArray tab, IDoubleArray val) {
        int c = 0;
        int i = 0;
        while (i < tab.rows()) {
            if (this.equal(tab.viewRow(i), val)) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public int countNonzero(IDoubleArray arr) {
        int res = 0;
        IDoubleIterator it = arr.nonzeroIterator();
        while (it.hasNext()) {
            ++res;
        }
        return res;
    }

    public int[] nonzeroIndexes1D(IDoubleArray arr) {
        IIntList list = API.intsNew.list(arr.rows());
        IDoubleIterator it = arr.nonzeroIterator();
        while (it.hasNext()) {
            IDoubleElement de = it.next();
            list.append(de.index());
        }
        return list.getArray();
    }

    public int[][] nonzeroIndexes2D(IDoubleArray arr) {
        int[][] res = new int[this.countNonzero(arr)][2];
        int k = 0;
        IDoubleIterator it = arr.nonzeroIterator();
        while (it.hasNext()) {
            IDoubleElement de = it.next();
            res[k][0] = de.row();
            res[k][1] = de.column();
            ++k;
        }
        return res;
    }

    public double maxInLine(IDoubleArray arr, int i) {
        return this.max(arr.viewRow(i));
    }

    public double maxInColumn(IDoubleArray arr, int i) {
        return this.max(arr.viewColumn(i));
    }

    public <T extends IDoubleArray> T removeRow(T arr, int index) {
        return this.removeIndex(arr, Ints.create.arrayFrom(index));
    }

    public <T extends IDoubleArray> T removeIndex(T arr, IIntArray index) {
        if (arr.size() == 0) {
            return arr;
        }
        IIntArray keep = Ints.util.removeValueToNew(Ints.create.arrayRange(arr.size()), index);
        return this.subRows(arr, keep);
    }

    public String toString(IDoubleArray arr, String coldel, String linedel) {
        return DoubleIO.toString(arr, coldel, linedel);
    }

    public void print(IDoubleArray arr, String coldel, String linedel) {
        DoubleIO.print(arr, coldel, linedel);
    }

    public String toString(IDoubleArray arr, String coldel, String linedel, int predig, int postdig) {
        return DoubleIO.toString(arr, coldel, linedel, predig, postdig);
    }

    public void print(IDoubleArray arr, String coldel, String linedel, int predig, int postdig) {
        DoubleIO.print(arr, coldel, linedel, predig, postdig);
    }

    public <T extends IDoubleArray> List<T> merge(List<T> l1, List<T> l2) {
        ArrayList<IDoubleArray> res = new ArrayList<IDoubleArray>();
        for (IDoubleArray o : l1) {
            res.add(o);
        }
        for (IDoubleArray o : l2) {
            res.add(o);
        }
        return res;
    }

    public <T extends IDoubleArray> List<T> subset(List<T> l1, IIntArray indexes) {
        ArrayList<IDoubleArray> res = new ArrayList<IDoubleArray>();
        int i = 0;
        while (i < indexes.size()) {
            res.add((IDoubleArray)l1.get(indexes.get(i)));
            ++i;
        }
        return res;
    }

    public void saveMatrixDense(IDoubleArray matrix, String filename) throws IOException {
        DoubleIO.writeMatrixDense(matrix, filename);
    }

    public void saveMatrixSparse(IDoubleArray matrix, String filename) throws IOException {
        DoubleIO.writeMatrixSparse(matrix, filename);
    }

    public void writeMatrixDense(IDoubleArray matrix, Appendable app) throws IOException {
        DoubleIO.writeMatrixDense(matrix, app);
    }

    public void writeMatrixSparse(IDoubleArray matrix, Appendable app) throws IOException {
        DoubleIO.writeMatrixSparse(matrix, app);
    }
}

