/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.dynamics;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.dynamics.IIntegrator;
import stallone.api.dynamics.IIntegratorThermostatted;
import stallone.api.potential.IEnergyModel;
import stallone.dynamics.BrownianDynamicsEuler;
import stallone.dynamics.LangevinLeapFrog;
import stallone.dynamics.VelocityVerlet;

public class DynamicsFactory {
    public IIntegratorThermostatted brownianDynamicsEuler(IEnergyModel model, IDoubleArray masses, double dt, double gamma, double kT) {
        BrownianDynamicsEuler res = new BrownianDynamicsEuler(dt, gamma, kT);
        res.setEnergyModel(model);
        res.setMasses(masses);
        return res;
    }

    public IIntegratorThermostatted langevinLeapFrog(IEnergyModel model, IDoubleArray masses, double dt, double gamma, double kT) {
        LangevinLeapFrog res = new LangevinLeapFrog(dt, gamma, kT);
        res.setEnergyModel(model);
        res.setMasses(masses);
        res.setV(API.dyn.maxwellBoltzmannVelocities(masses, kT));
        return res;
    }

    public IIntegrator velocityVerlet(IEnergyModel model, IDoubleArray masses, double dt) {
        VelocityVerlet res = new VelocityVerlet(dt);
        res.setEnergyModel(model);
        res.setMasses(masses);
        return res;
    }
}

