/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.dynamics;

import java.util.Random;
import stallone.api.API;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.datasequence.IDataWriter;
import stallone.api.doubles.IDoubleArray;
import stallone.api.dynamics.IIntegrator;

public class DynamicsUtilities {
    private static Random random = new Random();
    public static final double kB_kJmolK = 0.008314472616;

    public IDoubleArray maxwellBoltzmannVelocities(IDoubleArray masses, double kT) {
        IDoubleArray v = masses.copy();
        int i = 0;
        while (i < v.size()) {
            double sigma = Math.sqrt(kT / masses.get(i));
            v.set(i, sigma * random.nextGaussian());
            ++i;
        }
        return v;
    }

    public void run(IDoubleArray x0, IIntegrator integrator, IDataWriter crdOutput, int nsteps, int nsave) {
        integrator.setX(x0);
        int i = 0;
        while (i < nsteps) {
            integrator.step();
            if (i % nsave == 0) {
                crdOutput.add(integrator.getX());
            }
            ++i;
        }
    }

    public IDataSequence run(IDoubleArray x0, IIntegrator integrator, int nsteps, int nsave) {
        IDataList out = API.dataNew.list();
        integrator.setX(x0);
        int i = 0;
        while (i < nsteps) {
            integrator.step();
            if (i % nsave == 0) {
                out.add(integrator.getX().copy());
            }
            ++i;
        }
        return out;
    }
}

