/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.ints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.ints.IntIO;
import stallone.ints.QuickSortInt;

public class IntUtilities {
    private static IntIO io;

    public void fill(IIntArray arr, int d) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, d);
            ++i;
        }
    }

    public void mirror(IIntArray arr) {
        int n = arr.size();
        int nhalf = n / 2;
        int i = 0;
        while (i < nhalf) {
            int h = arr.get(i);
            arr.set(i, arr.get(n - 1 - i));
            arr.set(n - 1 - i, h);
            ++i;
        }
    }

    public void exchange(IIntArray arr, int i, int j) {
        int h = arr.get(i);
        arr.set(i, arr.get(j));
        arr.set(j, h);
    }

    public IIntArray addToNew(IIntArray arr1, int v) {
        IIntArray res = arr1.copy();
        int i = 0;
        while (i < res.size()) {
            res.set(i, res.get(i) + v);
            ++i;
        }
        return res;
    }

    public IIntArray addToNew(IIntArray arr1, IIntArray arr2) {
        IIntArray res = arr1.copy();
        int i = 0;
        while (i < res.size()) {
            res.set(i, res.get(i) + arr2.get(i));
            ++i;
        }
        return res;
    }

    public IIntArray addWeightedToNew(int w1, IIntArray arr1, int w2, IIntArray arr2) {
        if (arr1.size() != arr2.size()) {
            throw new IllegalArgumentException("incompatible vectors!");
        }
        IIntArray res = arr1.copy();
        int i = 0;
        while (i < arr1.size()) {
            res.set(i, w1 * arr1.get(i) + w2 * arr2.get(i));
            ++i;
        }
        return res;
    }

    public void increment(IIntArray arr, int d) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, arr.get(i) + d);
            ++i;
        }
    }

    public void increment(IIntArray arr, IIntArray d) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, arr.get(i) + d.get(i));
            ++i;
        }
    }

    public void scale(int a, IIntArray arr) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, a * arr.get(i));
            ++i;
        }
    }

    public IIntArray multiplyElementsToNew(IIntArray arr1, IIntArray arr2) {
        IIntArray res = arr1.create(arr1.size());
        int i = 0;
        while (i < res.size()) {
            res.set(i, arr1.get(i) * arr2.get(i));
            ++i;
        }
        return res;
    }

    public IIntArray divideElementsToNew(IIntArray arr1, IIntArray arr2) {
        IIntArray res = arr1.create(arr1.size());
        int i = 0;
        while (i < res.size()) {
            res.set(i, arr1.get(i) / arr2.get(i));
            ++i;
        }
        return res;
    }

    public void negate(IIntArray arr) {
        this.scale(-1, arr);
    }

    public void square(IIntArray arr) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, arr.get(i) * arr.get(i));
            ++i;
        }
    }

    public double sum(IIntArray arr) {
        double res = 0.0;
        int i = 0;
        while (i < arr.size()) {
            res += (double)arr.get(i);
            ++i;
        }
        return res;
    }

    public double distance(IIntArray arr1, IIntArray arr2) {
        double d = 0.0;
        int i = 0;
        while (i < arr1.size()) {
            double dev = arr1.get(i) - arr2.get(i);
            d += dev * dev;
            ++i;
        }
        return Math.sqrt(d);
    }

    public int count(IIntArray arr, int val) {
        int c = 0;
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) == val) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public boolean equal(IIntArray arr1, IIntArray arr2) {
        if (arr1.size() != arr2.size()) {
            return false;
        }
        int i = 0;
        while (i < arr1.size()) {
            double v2;
            double v1 = arr1.get(i);
            if (v1 != (v2 = (double)arr2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int maxIndex(IIntArray arr) {
        double m = Double.NEGATIVE_INFINITY;
        int im = 0;
        int i = 0;
        while (i < arr.size()) {
            if ((double)arr.get(i) > m) {
                m = arr.get(i);
                im = i;
            }
            ++i;
        }
        return im;
    }

    public int max(IIntArray arr) {
        return arr.get(this.maxIndex(arr));
    }

    public int minIndex(IIntArray arr) {
        double m = Double.POSITIVE_INFINITY;
        int im = 0;
        int i = 0;
        while (i < arr.size()) {
            if ((double)arr.get(i) < m) {
                m = arr.get(i);
                im = i;
            }
            ++i;
        }
        return im;
    }

    public int min(IIntArray arr) {
        return arr.get(this.minIndex(arr));
    }

    public IIntArray subToNew(IIntArray arr, int start, int end) {
        IIntArray res = Ints.create.array(end - start);
        int i = start;
        while (i < end) {
            res.set(i - start, arr.get(i));
            ++i;
        }
        return res;
    }

    public IIntArray subToNew(IIntArray arr, IIntArray indexes) {
        IIntArray res = Ints.create.array(indexes.size());
        int i = 0;
        while (i < indexes.size()) {
            res.set(i, arr.get(indexes.get(i)));
            ++i;
        }
        return res;
    }

    public IIntArray insertToNew(IIntArray arr, int index, int v) {
        IIntArray res = arr.create(arr.size() + 1);
        int j = 0;
        int i = 0;
        while (i < index) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        res.set(j, v);
        ++j;
        i = index;
        while (i < arr.size()) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        return res;
    }

    public IIntArray mergeToNew(Collection<IIntArray> a) {
        int size = 0;
        IIntArray template = null;
        for (IIntArray c : a) {
            if (template == null) {
                template = c;
            }
            size += c.size();
        }
        IIntArray res = template.create(size);
        int j = 0;
        for (IIntArray c : a) {
            int i = 0;
            while (i < c.size()) {
                res.set(j, c.get(i));
                ++j;
                ++i;
            }
        }
        return res;
    }

    public IIntArray mergeToNew(IIntArray a1, IIntArray a2) {
        IIntArray res = a1.create(a1.size() + a2.size());
        int j = 0;
        int i = 0;
        while (i < a1.size()) {
            res.set(j, a1.get(i));
            ++j;
            ++i;
        }
        i = 0;
        while (i < a2.size()) {
            res.set(j, a2.get(i));
            ++j;
            ++i;
        }
        return res;
    }

    public IIntArray mergeToNew(IIntArray a1, int a2) {
        IIntArray res = a1.create(a1.size() + 1);
        int i = 0;
        while (i < a1.size()) {
            res.set(i, a1.get(i));
            ++i;
        }
        res.set(res.size() - 1, a2);
        return res;
    }

    public void sort(IIntArray arr) {
        QuickSortInt qs = new QuickSortInt();
        qs.setData(arr, arr);
        qs.sort();
    }

    public IIntArray sortedIndexes(IIntArray arr) {
        QuickSortInt qs = new QuickSortInt();
        qs.setData(arr, arr.copy());
        qs.sort();
        return qs.getSortedIndexes();
    }

    public IIntArray cleanToNew(IIntArray arr) {
        IIntArray uncleaned = arr.copy();
        if (uncleaned.size() == 0) {
            return uncleaned;
        }
        this.sort(uncleaned);
        IIntList Iclean = Ints.create.list(uncleaned.size());
        Iclean.set(0, 0);
        int i = 1;
        while (i < uncleaned.size()) {
            if (uncleaned.get(i) != uncleaned.get(i - 1)) {
                Iclean.append(i);
            }
            ++i;
        }
        return this.subToNew(uncleaned, Iclean);
    }

    public IIntArray smallestIndexes(IIntArray arr, int n) {
        IIntArray indexes = this.sortedIndexes(arr);
        return this.subToNew(indexes, 0, n);
    }

    public IIntArray smallest(IIntArray arr, int n) {
        return this.subToNew(arr, this.smallestIndexes(arr, n));
    }

    public IIntArray largestIndexes(IIntArray arr, int n) {
        IIntArray indexes = this.sortedIndexes(arr);
        IIntArray largest = this.subToNew(indexes, indexes.size() - n, indexes.size());
        Ints.util.mirror(largest);
        return largest;
    }

    public IIntArray largest(IIntArray arr, int n) {
        return this.subToNew(arr, this.largestIndexes(arr, n));
    }

    public IIntArray smallValues(IIntArray arr, int maxValue) {
        return this.subToNew(arr, this.smallValueIndexes(arr, maxValue));
    }

    public IIntArray smallValueIndexes(IIntArray arr, int maxValue) {
        IIntList res = Ints.create.list(arr.size() / 2);
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) <= maxValue) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public IIntArray largeValues(IIntArray arr, int minValue) {
        return this.subToNew(arr, this.largeValueIndexes(arr, minValue));
    }

    public IIntArray largeValueIndexes(IIntArray arr, int minValue) {
        IIntList res = Ints.create.list(arr.size() / 2);
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) >= minValue) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public IIntArray within(IIntArray arr, int minVal, int maxVal) {
        return this.subToNew(arr, this.withinIndexes(arr, minVal, maxVal));
    }

    public IIntArray withinIndexes(IIntArray arr, int minVal, int maxVal) {
        IIntList res = Ints.create.list(arr.size() / 2);
        int i = 0;
        while (i < arr.size()) {
            if (minVal <= arr.get(i) && arr.get(i) < maxVal) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public int findForward(IIntArray arr, int val, int from) {
        int i = from;
        while (i < arr.get(i)) {
            if (arr.get(i) == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findForward(IIntArray arr, int val) {
        return this.findForward(arr, val, 0);
    }

    public int findBackwards(IIntArray arr, int val, int from) {
        int i = from;
        while (i >= 0) {
            if (arr.get(i) == val) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int findBackwards(IIntArray arr, int val) {
        return this.findBackwards(arr, val, 0);
    }

    private void findAll(IIntArray arr, int val, IIntList to) {
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) == val) {
                to.append(i);
            }
            ++i;
        }
    }

    public IIntList findAll(IIntArray arr, int val) {
        IIntList res = Ints.create.list(0);
        this.findAll(arr, val, res);
        return res;
    }

    public IIntList findAll(IIntArray arr, IIntArray vals) {
        IIntList res = Ints.create.list(0);
        int i = 0;
        while (i < vals.size()) {
            this.findAll(arr, vals.get(i), res);
            ++i;
        }
        return res;
    }

    public boolean contains(IIntArray arr, int val) {
        int i = 0;
        while (i < arr.size()) {
            if (arr.get(i) == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAny(IIntArray arr, IIntArray val) {
        int i = 0;
        while (i < val.size()) {
            if (this.contains(arr, val.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAll(IIntArray arr, IIntArray val) {
        int i = 0;
        while (i < val.size()) {
            if (!this.contains(arr, val.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int locateSorted(IIntArray arr, int num) {
        int l = 0;
        int m = arr.size() / 2;
        int r = arr.size();
        boolean found = false;
        while (!found) {
            if (num < arr.get(m)) {
                r = m;
                m = (r + l) / 2;
            } else if (num > arr.get(m)) {
                l = m;
                m = (r + l) / 2;
            } else {
                found = true;
            }
            if (m != l && m != r) continue;
            found = true;
        }
        found = false;
        while (!found) {
            if (m == 0) {
                found = true;
                continue;
            }
            if (arr.get(m - 1) != arr.get(m)) {
                found = true;
                continue;
            }
            --m;
        }
        if (num > arr.get(m)) {
            ++m;
        }
        return m;
    }

    public void insertSorted(IIntList arr, int num) {
        int i = this.locateSorted(arr, num);
        arr.insert(i, num);
    }

    public int insertSortedFixed(IIntArray arr, int num) {
        if (num >= arr.get(arr.size() - 1)) {
            return -1;
        }
        int i = arr.size() - 1;
        while (i >= 1) {
            if (arr.get(i - 1) < num) break;
            arr.set(i, arr.get(i - 1));
            --i;
        }
        arr.set(i, num);
        return i;
    }

    public int findSorted(IIntArray arr, int num) {
        int i = this.locateSorted(arr, num);
        if (arr.get(i) == num) {
            return i;
        }
        return -1;
    }

    public IIntList intersectionToNew(IIntArray arr1, IIntArray arr2) {
        IIntArray arr1c = this.cleanToNew(arr1);
        IIntArray arr2c = this.cleanToNew(arr2);
        IIntList res = Ints.create.list(Math.min(arr1c.size(), arr2c.size()));
        int i = 0;
        while (i < arr1c.size()) {
            int j = 0;
            while (j < arr2c.size()) {
                if (arr1c.get(i) == arr2c.get(j)) {
                    res.append(arr1c.get(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    public IIntArray unionToNew(IIntArray arr1, IIntArray arr2) {
        return this.cleanToNew(this.mergeToNew(arr1, arr2));
    }

    public IIntArray removeIndexToNew(IIntArray arr, int index) {
        IIntArray res = arr.create(arr.size() - 1);
        int j = 0;
        int i = 0;
        while (i < index) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        i = index + 1;
        while (i < arr.size()) {
            res.set(j, arr.get(i));
            ++j;
            ++i;
        }
        return res;
    }

    public IIntArray removeIndexToNew(IIntArray arr, IIntArray indexes) {
        if (arr.size() == 0) {
            return arr;
        }
        boolean[] exclude = new boolean[arr.size()];
        int nex = 0;
        int i = 0;
        while (i < indexes.size()) {
            if (!exclude[indexes.get(i)]) {
                exclude[indexes.get((int)i)] = true;
                ++nex;
            }
            ++i;
        }
        IIntArray res = arr.create(arr.size() - nex);
        int j = 0;
        int i2 = 0;
        while (i2 < arr.size()) {
            if (!exclude[i2]) {
                res.set(j, arr.get(i2));
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public IIntArray removeValueToNew(IIntArray arr1, IIntArray vals) {
        IIntList indexes = this.findAll(arr1, vals);
        return this.removeIndexToNew(arr1, indexes);
    }

    public IIntArray removeValueToNew(IIntArray arr1, int a2) {
        return this.removeValueToNew(arr1, Ints.create.arrayFrom(a2));
    }

    public String toString(IIntArray arr, String del) {
        return IntIO.toString(arr, del);
    }

    public void print(IIntArray arr, String del) {
        IntIO.print(arr, del);
    }

    public String toString(IIntArray arr, String coldel, String linedel) {
        return IntIO.toString(arr, coldel, linedel);
    }

    public void print(IIntArray arr, String coldel, String linedel) {
        IntIO.print(arr, coldel, linedel);
    }

    public String toString(IIntArray arr, String coldel, String linedel, int predig, int postdig) {
        return IntIO.toString(arr, coldel, linedel, predig, postdig);
    }

    public void print(IIntArray arr, String coldel, String linedel, int predig, int postdig) {
        IntIO.print(arr, coldel, linedel, predig, postdig);
    }

    public int sumRow(IIntArray arr, int row) {
        int res = 0;
        int i = 0;
        while (i < arr.columns()) {
            res += arr.get(row, i);
            ++i;
        }
        return res;
    }

    public int sumCol(IIntArray arr, int col) {
        int res = 0;
        int i = 0;
        while (i < arr.rows()) {
            res += arr.get(i, col);
            ++i;
        }
        return res;
    }

    public void transpose(IIntArray tab) {
        int ncols;
        int nrows = tab.rows();
        if (nrows != (ncols = tab.columns())) {
            throw new IllegalArgumentException("Cannot transpose in place if nrows differs from ncolumns. Use createTranspose in the factory");
        }
        int i = 0;
        while (i < nrows) {
            int j = i + 1;
            while (j < ncols) {
                int h = tab.get(i, j);
                tab.set(i, j, tab.get(j, i));
                tab.set(j, i, h);
                ++j;
            }
            ++i;
        }
    }

    public void copyInto(IIntArray source, int from, int to, IIntArray target, int bFrom) {
        if (from < 0 || to > source.size() || to < from || bFrom < 0 || bFrom > target.size()) {
            throw new IllegalArgumentException("Trying to copy array over boundaries of target");
        }
        int i = from;
        while (i < to) {
            target.set(i + bFrom, source.get(i));
            ++i;
        }
    }

    public void copyInto(IIntArray aFrom, int rowA0, int colA0, int rowA1, int colA1, IIntArray bTo, int rowB0, int colB0) {
        if (rowA0 < 0 || colA0 < 0 || bTo.rows() < rowB0 + (rowA1 - rowA0) || bTo.columns() < colB0 + (colA1 - colA0)) {
            throw new IllegalArgumentException("Trying to copy array over boundaries of target");
        }
        int i = rowA0;
        while (i < rowA1) {
            int j = colA0;
            while (j < colA1) {
                bTo.set(i + rowA0, j + colA0, aFrom.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void copyRowsInto(IIntArray aFrom, IIntArray bTo, int rowB0, int colB0) {
        this.copyInto(aFrom, 0, 0, aFrom.rows(), aFrom.columns(), bTo, rowB0, colB0);
    }

    public IIntArray mergeRowsToNew(IIntArray a1, IIntArray a2) {
        if (a1.columns() != a2.columns()) {
            throw new IllegalArgumentException("Trying to merge incompatible tables");
        }
        IIntArray res = Ints.create.table(a1.rows() + a2.rows(), a1.columns());
        this.copyRowsInto(a1, res, 0, 0);
        this.copyRowsInto(a2, res, a1.rows(), 0);
        return res;
    }

    public IIntArray insertRowToNew(IIntArray a, int rowIndex, IIntArray r) {
        if (a.columns() != r.size()) {
            throw new IllegalArgumentException("Trying to merge incompatible tables");
        }
        IIntArray res = Ints.create.table(a.rows() + 1, a.columns());
        this.copyInto(a, 0, 0, rowIndex, a.columns(), res, 0, 0);
        this.copyRowsInto(Ints.create.tableReshape(r, 1, r.size()), res, rowIndex, 0);
        this.copyInto(a, rowIndex, 0, a.rows(), a.columns(), res, rowIndex + 1, 0);
        return res;
    }

    public IIntArray subToNew(IIntArray a1, IIntArray rowIndexes, IIntArray colIndexes) {
        IIntArray res = Ints.create.table(rowIndexes.size(), colIndexes.size());
        int i = 0;
        while (i < rowIndexes.size()) {
            int j = 0;
            while (j < colIndexes.size()) {
                res.set(i, j, a1.get(rowIndexes.get(i), colIndexes.get(j)));
                ++j;
            }
            ++i;
        }
        return res;
    }

    public IIntArray subRowsToNew(IIntArray a1, IIntArray rowIndexes) {
        return this.subToNew(a1, rowIndexes, Ints.create.arrayRange(a1.columns()));
    }

    public IIntArray subColsToNew(IIntArray a1, IIntArray colIndexes) {
        return this.subToNew(a1, Ints.create.arrayRange(a1.rows()), colIndexes);
    }

    public int findRowForward(IIntArray arr, IIntArray val, int from) {
        int i = from;
        while (i < arr.get(i)) {
            if (this.equal(arr.viewRow(i), val)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findRowForward(IIntArray arr, IIntArray val) {
        return this.findRowForward(arr, val, 0);
    }

    public int findBackwards(IIntArray arr, IIntArray val, int from) {
        int i = from;
        while (i >= 0) {
            if (this.equal(arr.viewRow(i), val)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int findBackwards(IIntArray arr, IIntArray val) {
        return this.findBackwards(arr, val, 0);
    }

    public IIntArray findAllRows(IIntArray arr, IIntArray val) {
        IIntList res = Ints.create.list(0);
        int i = 0;
        while (i < arr.size()) {
            if (this.equal(arr.viewRow(i), val)) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }

    public int countRows(IIntArray tab, IIntArray val) {
        int c = 0;
        int i = 0;
        while (i < tab.rows()) {
            if (this.equal(tab.viewRow(i), val)) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public double maxInLine(IIntArray arr, int i) {
        return this.max(arr.viewRow(i));
    }

    public double maxInColumn(IIntArray arr, int i) {
        return this.max(arr.viewColumn(i));
    }

    public IIntArray removeRow(IIntArray arr, int index) {
        return this.removeIndex(arr, Ints.create.arrayFrom(index));
    }

    public IIntArray removeIndex(IIntArray arr, IIntArray index) {
        if (arr.size() == 0) {
            return arr;
        }
        IIntArray keep = Ints.util.removeValueToNew(Ints.create.arrayRange(arr.size()), index);
        return this.subRowsToNew(arr, keep);
    }

    public String toString(IIntArray arr) {
        return this.toString(arr, ",", "\n");
    }

    public void print(IIntArray arr) {
        System.out.println(this.toString(arr));
    }

    public <T extends IIntArray> List<T> merge(List<T> l1, List<T> l2) {
        ArrayList<IIntArray> res = new ArrayList<IIntArray>();
        for (IIntArray o : l1) {
            res.add(o);
        }
        for (IIntArray o : l2) {
            res.add(o);
        }
        return res;
    }

    public <T extends IIntArray> List<T> subset(List<T> l1, IIntArray indexes) {
        ArrayList<IIntArray> res = new ArrayList<IIntArray>();
        int i = 0;
        while (i < indexes.size()) {
            res.add((IIntArray)l1.get(indexes.get(i)));
            ++i;
        }
        return res;
    }
}

