/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.intsequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.api.intsequence.IntSequence;
import stallone.intsequence.IntSequenceWriterAsciiDense;
import stallone.intsequence.IntSequenceWriterAsciiSparse;

public class IntSequenceUtilities {
    public List<IIntArray> loadIntSequences(List<String> files) throws IOException {
        return IntSequence.create.intSequenceLoader(files).loadAll();
    }

    public IIntArray loadIntSequence(String file) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        files.add(file);
        return this.loadIntSequences(files).get(0);
    }

    public void writeIntSequence(IIntArray data, String file) throws IOException {
        IntSequenceWriterAsciiDense writer = new IntSequenceWriterAsciiDense(file);
        writer.addAll(data);
        writer.close();
    }

    public void writeIntSequences(List<IIntArray> data, List<String> files) throws IOException {
        if (data.size() != files.size()) {
            throw new IllegalArgumentException("Number of sequences is different from number of target files");
        }
        int itraj = 0;
        while (itraj < data.size()) {
            this.writeIntSequence(data.get(itraj), files.get(itraj));
            ++itraj;
        }
    }

    public void writeIntSequenceSparse(IIntArray data, String file) throws IOException {
        IntSequenceWriterAsciiSparse writer = new IntSequenceWriterAsciiSparse(file);
        writer.addAll(data);
        writer.close();
    }

    public void writeIntSequencesSparse(List<IIntArray> data, List<String> files) throws IOException {
        if (data.size() != files.size()) {
            throw new IllegalArgumentException("Number of sequences is different from number of target files");
        }
        int itraj = 0;
        while (itraj < data.size()) {
            this.writeIntSequenceSparse(data.get(itraj), files.get(itraj));
            ++itraj;
        }
    }

    public int max(Iterable<IIntArray> paths) {
        int n = 0;
        for (IIntArray p : paths) {
            n = Math.max(n, Ints.util.max(p));
        }
        return n;
    }

    public List<int[]> lifetimesByEvent(IIntArray path) {
        ArrayList<int[]> res = new ArrayList<int[]>();
        int begin = 0;
        int t = 1;
        while (t < path.size()) {
            if (path.get(t) != path.get(begin)) {
                int state = path.get(begin);
                int time = t - begin;
                res.add(new int[]{state, time});
                begin = t;
            }
            ++t;
        }
        int state = path.get(begin);
        int time = path.size() - begin;
        res.add(new int[]{state, time});
        return res;
    }

    public IIntList[] lifetimesByState(IIntArray path) {
        int nstates = Ints.util.max(path) + 1;
        IIntList[] lists = new IIntList[nstates];
        int i = 0;
        while (i < lists.length) {
            lists[i] = Ints.create.list(0);
            ++i;
        }
        int begin = 0;
        int t = 1;
        while (t < path.size()) {
            if (path.get(t) != path.get(begin)) {
                lists[path.get(begin)].append(t - begin);
                begin = t;
            }
            ++t;
        }
        return lists;
    }

    public IIntList[] lifetimesByState(List<IIntArray> paths) {
        IIntList[] res = new IIntList[this.max(paths) + 1];
        int i = 0;
        while (i < res.length) {
            res[i] = Ints.create.list(0);
            ++i;
        }
        for (IIntArray path : paths) {
            IIntList[] ttimes = this.lifetimesByState(path);
            int s = 0;
            while (s < ttimes.length) {
                res[s].appendAll(ttimes[s]);
                ++s;
            }
        }
        return res;
    }

    public double[][] cumulativeLifetimeDistribution(List<IIntArray> paths) {
        IIntList[] times = this.lifetimesByState(paths);
        int nstates = times.length;
        int maxtime = 0;
        IIntList[] iIntListArray = times;
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            IIntList l = iIntListArray[n2];
            if (l.size() > 0) {
                maxtime = Math.max(maxtime, Ints.util.max(l));
            }
            ++n2;
        }
        double[][] cumdist = new double[maxtime + 1][nstates];
        int s = 0;
        while (s < nstates) {
            Ints.util.sort(times[s]);
            Ints.util.mirror(times[s]);
            int n3 = 0;
            int t = cumdist.length - 1;
            while (t >= 0) {
                if (times[s].size() > 0) {
                    while (times[s].get(n3) >= t && n3 < times[s].size() - 1) {
                        ++n3;
                    }
                    cumdist[t][s] = (double)n3 / (double)times[s].size();
                }
                --t;
            }
            ++s;
        }
        return cumdist;
    }

    public int[] lengths(List<IIntArray> dtrajs) {
        int[] res = new int[dtrajs.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = dtrajs.size();
            ++i;
        }
        return res;
    }
}

