/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.io.IOException;
import stallone.api.API;
import stallone.api.datasequence.IDataSequence;
import stallone.api.ints.IIntArray;
import stallone.cluster.AbstractRegularClustering;
import stallone.cluster.RandomClustering;
import stallone.doubles.EuclideanDistance;

public class CompactRandomClustering
extends AbstractRegularClustering {
    private RandomClustering bestClustering;
    private int nclusters = 2;
    private int nrepeat = 0;

    public CompactRandomClustering(int _nClusters, int _nrepeat) {
        this.nclusters = _nClusters;
        if (_nrepeat > 1) {
            this.nrepeat = _nrepeat;
        }
    }

    @Override
    public void perform() {
        this.bestClustering = new RandomClustering(this.nclusters);
        this.bestClustering.setMetric(this.metric);
        this.bestClustering.data = this.data;
        this.bestClustering.datasize = this.datasize;
        this.bestClustering.perform();
        double DB = API.cluster.clusterIndexDaviesBouldin(this.data, this.bestClustering.getClusterCenters(), this.metric, this.bestClustering.getClusterIndexes());
        int i = 1;
        while (i < this.nrepeat) {
            RandomClustering rcnew = new RandomClustering(this.nclusters);
            rcnew.setMetric(this.metric);
            rcnew.data = this.data;
            rcnew.datasize = this.datasize;
            rcnew.perform();
            double DBnew = API.cluster.clusterIndexDaviesBouldin(this.data, rcnew.getClusterCenters(), this.metric, rcnew.getClusterIndexes());
            if (DBnew < DB) {
                DB = DBnew;
                this.bestClustering = rcnew;
            }
            ++i;
        }
        System.out.println("Choose clustering with DB = " + DB);
        this.clusterCenters = this.bestClustering.getClusterCenters();
        this.voronoiPartitioning = this.bestClustering.voronoiPartitioning;
        this.resultsAvailable = true;
    }

    @Override
    public IIntArray getClusterIndexes() {
        return this.bestClustering.getClusterIndexes();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("CompactRandomClustering <datafile> <nclusters> <nrepeats>");
            System.exit(0);
        }
        IDataSequence data = API.dataNew.reader(args[0]).load();
        int nclusters = API.str.toInt(args[1]);
        int nrepeats = API.str.toInt(args[2]);
        CompactRandomClustering C = new CompactRandomClustering(nclusters, nrepeats);
        C.setInput(data);
        C.setMetric(new EuclideanDistance());
        C.perform();
        IIntArray assign = C.getClusterIndexes();
        API.ints.print(assign, "", "\n");
    }
}

