/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import stallone.api.cluster.INeighborSearch;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.cluster.AbstractRegularClustering;
import stallone.cluster.NeighborSearchTrivial;
import stallone.doubles.EuclideanDistance;
import stallone.doubles.PrimitiveDoubleTools;

public class DensityBasedClusteringOPTICS
extends AbstractRegularClustering {
    private IDataSequence datasequence;
    private INeighborSearch neighborSearch;
    private boolean[] processed;
    private int[] numberOfNeighbors;
    private double[] reachability_distance;
    private int[] orderedPoints;
    private int[] clusterIndexes;
    private double eps;
    private int minpts;
    private int nclusters;

    public DensityBasedClusteringOPTICS(double _epsilon, int _minpoints, int _nclusters) {
        this.eps = _epsilon;
        this.minpts = _minpoints;
        this.nclusters = _nclusters;
        this.neighborSearch = new NeighborSearchTrivial(null, new EuclideanDistance());
    }

    @Override
    public void setInput(IDataSequence data) {
        super.setInput(data);
        this.datasequence = data;
        this.neighborSearch.setData(data);
        this.reachability_distance = new double[data.size()];
        Arrays.fill(this.reachability_distance, -1.0);
        this.processed = new boolean[data.size()];
        Arrays.fill(this.processed, false);
        this.orderedPoints = new int[data.size()];
    }

    @Override
    public void setInput(IDataInput data) {
        throw new RuntimeException("Currently not implemented");
    }

    @Override
    public void setMetric(IMetric<IDoubleArray> metric) {
        super.setMetric(metric);
        this.neighborSearch.setMetric(metric);
    }

    @Override
    public void perform() {
        this.clusterCenters = DataSequence.create.list();
        this.optics();
        int[] nArray = this.orderedPoints;
        int n = this.orderedPoints.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            System.out.println(String.valueOf(p) + "\t" + this.reachability_distance[p]);
            ++n2;
        }
        System.exit(0);
        this.selectClusters();
    }

    private double coreDistance(int i) {
        int[] neighbors = this.neighborSearch.neighbors(i, this.eps);
        if (neighbors.length < this.minpts) {
            return -1.0;
        }
        double[] distances = new double[neighbors.length];
        int j = 0;
        while (j < distances.length) {
            distances[j] = this.metric.distance(this.datasequence.get(i), this.datasequence.get(neighbors[j]));
            ++j;
        }
        PrimitiveDoubleTools.sort(distances);
        return distances[this.minpts - 1];
    }

    public double reachabilityDistance(int i, int j) {
        double cd = this.coreDistance(j);
        if (cd == -1.0) {
            return -1.0;
        }
        return Math.max(cd, this.metric.distance(this.datasequence.get(i), this.datasequence.get(j)));
    }

    private void optics() {
        int nprocessed = 0;
        int i = 0;
        while (i < this.processed.length) {
            System.out.println("Processing " + i);
            if (!this.processed[i]) {
                int[] N = this.neighborSearch.neighbors(i, this.eps);
                this.processed[i] = true;
                System.out.println(" Neighbors: " + Ints.util.toString(Ints.create.arrayFrom(N)));
                this.orderedPoints[nprocessed] = i;
                ++nprocessed;
                PriorityQueue<Integer> seeds = new PriorityQueue<Integer>();
                double coredist_i = this.coreDistance(i);
                System.out.println(" core distance: " + coredist_i);
                if (coredist_i != -1.0) {
                    this.update(N, i, seeds);
                    while (!seeds.isEmpty()) {
                        int q = seeds.poll();
                        System.out.println("  polling " + q);
                        int[] N2 = this.neighborSearch.neighbors(q, this.eps);
                        this.processed[q] = true;
                        this.orderedPoints[nprocessed] = q;
                        ++nprocessed;
                        if (this.coreDistance(q) == -1.0) continue;
                        this.update(N2, q, seeds);
                    }
                }
            }
            ++i;
        }
    }

    private void update(int[] neighbors, int p, PriorityQueue<Integer> seeds) {
        double coredist = this.coreDistance(p);
        int[] nArray = neighbors;
        int n = neighbors.length;
        int n2 = 0;
        while (n2 < n) {
            int o = nArray[n2];
            if (!this.processed[o]) {
                double newReachDist = Math.max(coredist, this.metric.distance(this.datasequence.get(o), this.datasequence.get(p)));
                if (this.reachability_distance[o] == -1.0) {
                    this.reachability_distance[o] = newReachDist;
                    seeds.add(o);
                } else if (newReachDist < this.reachability_distance[o]) {
                    this.reachability_distance[o] = newReachDist;
                    seeds.remove(o);
                    seeds.add(o);
                }
            }
            ++n2;
        }
    }

    private void selectClusters() {
        double rmin = 0.0;
        double rmax = PrimitiveDoubleTools.max(this.reachability_distance);
        double r = rmax / 2.0;
        int nclusters = 0;
        boolean inACluster = false;
        int[] nArray = this.orderedPoints;
        int n = this.orderedPoints.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (r < this.reachability_distance[p]) {
                if (inACluster) {
                    this.clusterIndexes[p] = nclusters - 1;
                } else {
                    inACluster = true;
                    this.clusterIndexes[p] = ++nclusters - 1;
                }
            }
            ++n2;
        }
    }

    @Override
    public IIntArray getClusterIndexes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        IDataList data = DataSequence.create.list();
        data.add(Doubles.create.arrayFrom(-1.4));
        data.add(Doubles.create.arrayFrom(-1.0));
        data.add(Doubles.create.arrayFrom(1.0));
        data.add(Doubles.create.arrayFrom(1.1));
        data.add(Doubles.create.arrayFrom(1.2));
        data.add(Doubles.create.arrayFrom(-1.3));
        data.add(Doubles.create.arrayFrom(-1.2));
        data.add(Doubles.create.arrayFrom(-1.1));
        data.add(Doubles.create.arrayFrom(1.3));
        data.add(Doubles.create.arrayFrom(1.4));
        DensityBasedClusteringOPTICS clustering = new DensityBasedClusteringOPTICS(0.5, 2, 2);
        clustering.setInput(data);
        clustering.setMetric(new EuclideanDistance());
        clustering.perform();
    }

    class OrderedPointComparator
    implements Comparator<Integer> {
        OrderedPointComparator() {
        }

        @Override
        public int compare(Integer p1, Integer p2) {
            if (DensityBasedClusteringOPTICS.this.reachability_distance[p1] < DensityBasedClusteringOPTICS.this.reachability_distance[p2]) {
                return -1;
            }
            if (DensityBasedClusteringOPTICS.this.reachability_distance[p1] > DensityBasedClusteringOPTICS.this.reachability_distance[p2]) {
                return 1;
            }
            return 0;
        }
    }
}

