/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Arrays;
import java.util.TreeSet;
import stallone.api.cluster.INeighborSearch;
import stallone.api.datasequence.DataSequence;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.cluster.AbstractRegularClustering;
import stallone.cluster.NeighborSearchTrivial;
import stallone.doubles.EuclideanDistance;
import stallone.ints.PrimitiveIntTools;

public class DensityBasedClusteringSimple
extends AbstractRegularClustering {
    protected IDataSequence datasequence;
    protected INeighborSearch neighborSearch = new NeighborSearchTrivial(null, new EuclideanDistance());
    private int[] nneighbors;
    private int[] cluster;
    private int nClusters;
    private boolean[] done;
    protected double eps;
    protected int minpts;

    protected DensityBasedClusteringSimple() {
    }

    public DensityBasedClusteringSimple(double _epsilon, int _minpoints) {
        this.eps = _epsilon;
        this.minpts = _minpoints;
    }

    @Override
    public void setInput(IDataSequence data) {
        super.setInput(data);
        this.datasequence = data;
        this.neighborSearch.setData(data);
        this.nneighbors = new int[data.size()];
        this.cluster = new int[data.size()];
        this.done = new boolean[data.size()];
    }

    @Override
    public void setInput(IDataInput data) {
        throw new RuntimeException("Currently not implemented");
    }

    @Override
    public void setMetric(IMetric<IDoubleArray> metric) {
        super.setMetric(metric);
        this.neighborSearch.setMetric(metric);
    }

    @Override
    public void perform() {
        this.clusterCenters = DataSequence.create.list();
        Arrays.fill(this.nneighbors, -1);
        Arrays.fill(this.nneighbors, -1);
        Arrays.fill(this.done, false);
        int i = 0;
        while (i < this.nneighbors.length) {
            this.nneighbors[i] = this.neighborSearch.neighbors(i, this.eps).length;
            ++i;
        }
        int[] orderedPoints = PrimitiveIntTools.mirror(PrimitiveIntTools.sortedIndexes(this.nneighbors));
        int currentCluster = -1;
        int[] nArray = orderedPoints;
        int n = orderedPoints.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (!this.done[p]) {
                int[] N;
                this.cluster[p] = ++currentCluster;
                this.done[p] = true;
                TreeSet<Integer> colleagues = new TreeSet<Integer>();
                int[] nArray2 = N = this.neighborSearch.neighbors(p, this.eps);
                int n3 = N.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i2 = nArray2[n4];
                    colleagues.add(i2);
                    ++n4;
                }
                while (!colleagues.isEmpty()) {
                    int[] N2;
                    int q = (Integer)colleagues.pollFirst();
                    if (this.nneighbors[q] <= this.minpts) continue;
                    this.cluster[q] = currentCluster;
                    int[] nArray3 = N2 = this.neighborSearch.neighbors(q, this.eps);
                    int n5 = N2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int i3 = nArray3[n6];
                        if (this.nneighbors[i3] > this.minpts && !this.done[i3]) {
                            colleagues.add(i3);
                        }
                        ++n6;
                    }
                    this.done[q] = true;
                }
            }
            ++n2;
        }
        this.nClusters = currentCluster + 1;
        this.resultsAvailable = true;
    }

    @Override
    public IIntArray getClusterIndexes() {
        return Ints.create.arrayFrom(this.cluster);
    }

    @Override
    public int getNumberOfClusters() {
        return this.nClusters;
    }

    public static void main(String[] args) {
        IDataList data = DataSequence.create.list();
        data.add(Doubles.create.arrayFrom(-1.4));
        data.add(Doubles.create.arrayFrom(-1.3));
        data.add(Doubles.create.arrayFrom(-1.2));
        data.add(Doubles.create.arrayFrom(-1.1));
        data.add(Doubles.create.arrayFrom(-1.0));
        data.add(Doubles.create.arrayFrom(0.5));
        data.add(Doubles.create.arrayFrom(1.0));
        data.add(Doubles.create.arrayFrom(1.1));
        data.add(Doubles.create.arrayFrom(1.2));
        data.add(Doubles.create.arrayFrom(1.3));
        data.add(Doubles.create.arrayFrom(1.4));
        double d = 0.0;
        while (d < 4.0) {
            DensityBasedClusteringSimple clustering = new DensityBasedClusteringSimple(d, 3);
            clustering.setInput(data);
            clustering.setMetric(new EuclideanDistance());
            clustering.perform();
            System.out.println(String.valueOf(d) + "\t" + clustering.getNumberOfClusters());
            d += 0.1;
        }
    }
}

