/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import stallone.api.cluster.INeighborSearch;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.discretization.VoronoiDiscretization;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;

public class NeighborSearchTrivial
implements INeighborSearch {
    private IDataSequence data;
    private IMetric<IDoubleArray> metric;
    private VoronoiDiscretization voronoi;

    public NeighborSearchTrivial(IDataSequence clusterCenters, IMetric<IDoubleArray> metric) {
        this.data = clusterCenters;
        this.metric = metric;
        this.voronoi = new VoronoiDiscretization(clusterCenters, metric);
    }

    @Override
    public void setData(IDataSequence _data) {
        this.data = _data;
        this.voronoi.setClusterCenters(_data);
    }

    @Override
    public void setMetric(IMetric<IDoubleArray> m) {
        this.metric = m;
        this.voronoi.setMetric(m);
    }

    @Override
    public int nearestNeighbor(int index) {
        return this.voronoi.assign(this.data.get(index));
    }

    @Override
    public int nearestNeighbor(IDoubleArray x) {
        return this.voronoi.assign(x);
    }

    @Override
    public int[] nearestNeighbors(int index, int N) {
        return this.nearestNeighbors(this.data.get(index), N);
    }

    @Override
    public int[] nearestNeighbors(IDoubleArray x, int N) {
        double[] distances = new double[this.data.size()];
        int i = 0;
        while (i < this.data.size()) {
            distances[i] = this.metric.distance(x, this.data.get(i));
            ++i;
        }
        int[] res = PrimitiveDoubleTools.smallestIndexes(distances, N);
        return res;
    }

    @Override
    public int[] neighbors(int index, double distance) {
        return PrimitiveIntTools.removeByValue(this.neighbors(this.data.get(index), distance), index);
    }

    @Override
    public int[] neighbors(IDoubleArray x, double distance) {
        double[] distances = new double[this.data.size()];
        int i = 0;
        while (i < this.data.size()) {
            distances[i] = this.metric.distance(x, this.data.get(i));
            ++i;
        }
        int[] res = PrimitiveDoubleTools.smallValueIndexes(distances, distance);
        return res;
    }
}

