/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import stallone.api.ints.IIndexMap;

public class RegularIntervalMapping
implements IIndexMap {
    private int from;
    private int to;
    private int stepwidth;
    private int size;

    public RegularIntervalMapping(int from, int to, int stepwidth) {
        this.from = from;
        this.to = to;
        this.stepwidth = stepwidth;
        this.size = (to - from) / stepwidth;
    }

    @Override
    public int map(int i) {
        if (i >= 0 && i < this.size) {
            return this.from + i * this.stepwidth;
        }
        throw new RuntimeException("Index i is not 0 <= i < size.");
    }

    @Override
    public int size() {
        return this.size;
    }

    public static RegularIntervalMapping createInstance(int from, int to, int stepwidth) {
        return new RegularIntervalMapping(from, to, stepwidth);
    }
}

