/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Iterator;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.cluster.AbstractRegularClustering;
import stallone.datasequence.DataList;
import stallone.discretization.VoronoiDiscretization;

public class RegularSpatialClustering
extends AbstractRegularClustering
implements IClustering {
    private double dmin;

    public RegularSpatialClustering() {
    }

    public RegularSpatialClustering(IMetric<IDoubleArray> metric, IDataSequence data, double dmin) {
        this.metric = metric;
        this.data = data;
        this.dmin = dmin;
        this.resultsAvailable = false;
        this.clusterCenters = null;
        this.voronoiPartitioning = null;
    }

    public void setDmin(double dmin) {
        this.dmin = dmin;
        this.resultsAvailable = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void perform() {
        DataList centroids = new DataList();
        Iterator it = this.data.iterator();
        if (this.datasize <= 0) {
            throw new RuntimeException("No first element .... aborting.");
        }
        centroids.add((IDoubleArray)it.next());
        while (it.hasNext()) {
            int minIndex;
            IDoubleArray current = (IDoubleArray)it.next();
            double[] d = RegularSpatialClustering.calculateDistances(centroids, current, this.metric);
            if (!(d[minIndex = RegularSpatialClustering.minIndex(d)] >= this.dmin)) continue;
            centroids.add(current);
            System.out.println(String.valueOf(d[minIndex]) + "\t" + centroids.size());
        }
        this.clusterCenters = centroids;
        this.voronoiPartitioning = new VoronoiDiscretization(this.clusterCenters, this.metric);
        this.resultsAvailable = true;
    }

    private static double[] calculateDistances(IDataSequence xs, IDoubleArray y, IMetric<IDoubleArray> metric) {
        int n = xs.size();
        double[] distances = new double[n];
        int i = 0;
        while (i < n) {
            distances[i] = metric.distance(xs.get(i), y);
            ++i;
        }
        return distances;
    }

    public static int minIndex(double[] arr) {
        double min = Double.POSITIVE_INFINITY;
        int minIndex = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] < min) {
                min = arr[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public String getDescriptiveName() {
        return "regularspatialspaced";
    }

    @Override
    public IIntArray getClusterIndexes() {
        return Ints.create.arrayRange(super.getNumberOfClusters());
    }
}

