/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex;

import java.io.Serializable;
import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.complex.ImaginaryView;
import stallone.api.doubles.IDoubleArray;
import stallone.complex.ComplexArrayIterator;
import stallone.complex.ComplexArrayNonzeroIterator;
import stallone.complex.ComplexArrayView;
import stallone.doubles.AbstractDoubleArray;

public abstract class AbstractComplexArray
extends AbstractDoubleArray
implements IComplexArray,
Serializable {
    @Override
    public int order() {
        int order = 0;
        if (this.rows() > 1) {
            ++order;
        }
        if (this.columns() > 1) {
            ++order;
        }
        return order;
    }

    @Override
    public boolean isReal() {
        IComplexIterator it = this.nonzeroComplexIterator();
        while (it.hasNext()) {
            if (it.getIm() != 0.0) {
                return false;
            }
            it.advance();
        }
        return true;
    }

    @Override
    public double get(int i, int j) {
        return this.getRe(i, j);
    }

    @Override
    public void set(int i, int j, double value) {
        this.setRe(i, j, value);
    }

    @Override
    public double get(int ij) {
        return this.getRe(ij / this.columns(), ij % this.columns());
    }

    @Override
    public double getRe(int ij) {
        return this.getRe(ij / this.columns(), ij % this.columns());
    }

    @Override
    public double getIm(int ij) {
        return this.getIm(ij / this.columns(), ij % this.columns());
    }

    @Override
    public void set(int ij, double value) {
        this.setRe(ij / this.columns(), ij % this.columns(), value);
    }

    @Override
    public void setRe(int ij, double value) {
        this.setRe(ij / this.columns(), ij % this.columns(), value);
    }

    @Override
    public void setIm(int ij, double value) {
        this.setIm(ij / this.columns(), ij % this.columns(), value);
    }

    @Override
    public void set(int i, double re, double im) {
        this.setRe(i, re);
        this.setIm(i, im);
    }

    @Override
    public void set(int i, int j, double re, double im) {
        this.setRe(i, j, re);
        this.setIm(i, j, im);
    }

    @Override
    public void zero() {
        IComplexIterator it = this.complexIterator();
        while (it.hasNext()) {
            it.set(0.0, 0.0);
            it.advance();
        }
    }

    @Override
    public void copyFrom(IComplexArray other) {
        int _size = other.size();
        if (_size != this.size()) {
            throw new IllegalArgumentException("Trying to copy from array with different size");
        }
        int i = 0;
        while (i < _size) {
            this.set(i, other.getRe(i), this.getIm(i));
            ++i;
        }
    }

    @Override
    public void copyInto(IComplexArray other) {
        int _size = other.size();
        if (_size != this.size()) {
            throw new IllegalArgumentException("Trying to copy from array with different size");
        }
        int i = 0;
        while (i < _size) {
            other.set(i, this.getRe(i), this.getIm(i));
            ++i;
        }
    }

    @Override
    public double[] getRealArray() {
        return this.getArray();
    }

    @Override
    public double[] getImaginaryArray() {
        double[] res = new double[this.rows() * this.columns()];
        int i = 0;
        while (i < res.length) {
            res[i] = this.getIm(i);
            ++i;
        }
        return res;
    }

    @Override
    public double[] getRealRow(int row) {
        return this.getRow(row);
    }

    @Override
    public double[] getRealColumn(int col) {
        return this.getColumn(col);
    }

    @Override
    public double[] getImaginaryRow(int row) {
        double[] res = new double[this.columns()];
        int i = 0;
        while (i < res.length) {
            res[i] = this.getIm(row, i);
            ++i;
        }
        return res;
    }

    @Override
    public double[] getImaginaryColumn(int col) {
        double[] res = new double[this.columns()];
        int i = 0;
        while (i < res.length) {
            res[i] = this.getIm(i, col);
            ++i;
        }
        return res;
    }

    @Override
    public double[][] getRealTable() {
        return this.getTable();
    }

    @Override
    public double[][] getImaginaryTable() {
        double[][] res = new double[this.rows()][this.columns()];
        IComplexIterator it = this.complexIterator();
        while (it.hasNext()) {
            res[it.row()][it.column()] = it.getIm();
            it.advance();
        }
        return res;
    }

    @Override
    public IComplexIterator complexIterator() {
        return new ComplexArrayIterator(this);
    }

    @Override
    public IComplexIterator nonzeroComplexIterator() {
        return new ComplexArrayNonzeroIterator(this);
    }

    @Override
    public IComplexArray viewRow(int r) {
        return new ComplexArrayView(this, r, 0, r + 1, this.columns());
    }

    @Override
    public IComplexArray viewColumn(int column) {
        return new ComplexArrayView(this, 0, column, this.rows(), column + 1);
    }

    @Override
    public IComplexArray viewBlock(int startRow, int startColumn, int endRow, int endColumn) {
        return new ComplexArrayView(this, startRow, startColumn, endRow, endColumn);
    }

    @Override
    public IComplexArray view(int[] selectedRows, int[] selectedColumns) {
        return new ComplexArrayView((IComplexArray)this, selectedRows, selectedColumns);
    }

    @Override
    public IDoubleArray viewReal() {
        return this;
    }

    @Override
    public IDoubleArray viewImaginary() {
        return new ImaginaryView(this);
    }

    @Override
    public String toString() {
        StringBuilder strBuf = new StringBuilder();
        int rows = this.rows();
        int cols = this.columns();
        if (!this.isReal()) {
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < cols) {
                    strBuf.append(String.valueOf(this.getRe(i)) + " " + this.getIm(i) + "i ");
                    ++j;
                }
                strBuf.append("\n");
                ++i;
            }
        } else {
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < cols) {
                    strBuf.append(String.valueOf(this.getRe(i, j)) + " ");
                    ++j;
                }
                strBuf.append("\n");
                ++i;
            }
        }
        System.out.println("done");
        return strBuf.toString();
    }
}

