/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex;

import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.complex.AbstractComplexArray;
import stallone.doubles.ArrayIndexMap;
import stallone.doubles.IArrayIndexMap;

public class ComplexArrayView
extends AbstractComplexArray {
    protected IComplexArray carr;
    protected IArrayIndexMap map;

    public ComplexArrayView(IComplexArray _data, int _top, int _left, int _bottom, int _right) {
        this.carr = _data;
        this.map = ArrayIndexMap.createMap(_data, _top, _left, _bottom, _right);
    }

    public ComplexArrayView(IComplexArray _data, int _from, int _to) {
        this.carr = _data;
        this.map = ArrayIndexMap.createMap((IDoubleArray)_data, _from, _to);
    }

    public ComplexArrayView(IComplexArray _data, int[] rowIndexes, int[] colIndexes) {
        this.carr = _data;
        this.map = ArrayIndexMap.createMap((IDoubleArray)_data, Ints.create.arrayFrom(rowIndexes), Ints.create.arrayFrom(colIndexes));
    }

    public ComplexArrayView(IComplexArray _data, IIntArray rowIndexes, IIntArray colIndexes) {
        this.carr = _data;
        this.map = ArrayIndexMap.createMap((IDoubleArray)_data, rowIndexes, colIndexes);
    }

    public ComplexArrayView(IComplexArray _data, int[] indexes) {
        this.carr = _data;
        this.map = ArrayIndexMap.createMap(_data, Ints.create.arrayFrom(indexes));
    }

    public ComplexArrayView(IComplexArray _data, IIntArray indexes) {
        this.carr = _data;
        this.map = ArrayIndexMap.createMap(_data, indexes);
    }

    @Override
    public int rows() {
        return this.map.rows();
    }

    @Override
    public int columns() {
        return this.map.columns();
    }

    @Override
    public boolean isReal() {
        return this.carr.isReal();
    }

    @Override
    public double getRe(int i, int j) {
        return this.carr.getRe(this.map.getRow(i), this.map.getColumn(j));
    }

    @Override
    public void setRe(int i, int j, double x) {
        this.carr.setRe(this.map.getRow(i), this.map.getColumn(j), x);
    }

    @Override
    public double getIm(int i, int j) {
        return this.carr.getIm(this.map.getRow(i), this.map.getColumn(j));
    }

    @Override
    public void setIm(int i, int j, double x) {
        this.carr.setIm(this.map.getRow(i), this.map.getColumn(j), x);
    }

    @Override
    public IComplexArray copy() {
        IComplexArray res = this.create(this.map.rows(), this.map.columns());
        this.copyInto(res);
        return res;
    }

    @Override
    public IComplexArray create(int size) {
        return this.carr.create(size);
    }

    @Override
    public IComplexArray create(int rows, int cols) {
        return this.carr.create(rows, cols);
    }

    @Override
    public boolean isSparse() {
        return this.carr.isSparse();
    }
}

