/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex;

import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.complex.AbstractComplexArray;
import stallone.complex.ComplexArrayView;

public class ComplexDoubleArrayView
extends AbstractComplexArray {
    private IDoubleArray darr;
    private ComplexArrayView rowview = null;
    private ComplexArrayView colview = null;

    public ComplexDoubleArrayView(IDoubleArray _darr) {
        this.darr = _darr;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public double getRe(int i) {
        return this.darr.get(i);
    }

    @Override
    public double getRe(int i, int j) {
        return this.darr.get(i, j);
    }

    @Override
    public void setRe(int i, double x) {
        this.darr.set(i, x);
    }

    @Override
    public void setRe(int i, int j, double x) {
        this.darr.set(i, j, x);
    }

    @Override
    public double getIm(int i) {
        throw new UnsupportedOperationException("No imaginary part supported");
    }

    @Override
    public double getIm(int i, int j) {
        throw new UnsupportedOperationException("No imaginary part supported");
    }

    @Override
    public void setIm(int i, double x) {
        throw new UnsupportedOperationException("No imaginary part supported");
    }

    @Override
    public void setIm(int i, int j, double x) {
        throw new UnsupportedOperationException("No imaginary part supported");
    }

    @Override
    public double[] getRealArray() {
        return this.darr.getArray();
    }

    @Override
    public double[] getImaginaryArray() {
        return new double[this.darr.size()];
    }

    @Override
    public double[][] getRealTable() {
        return this.darr.getTable();
    }

    @Override
    public double[][] getImaginaryTable() {
        return new double[this.darr.rows()][this.darr.columns()];
    }

    @Override
    public double[] getRealRow(int i) {
        return this.darr.getRow(i);
    }

    @Override
    public double[] getImaginaryRow(int i) {
        return new double[this.darr.columns()];
    }

    @Override
    public double[] getRealColumn(int j) {
        return this.darr.getColumn(j);
    }

    @Override
    public double[] getImaginaryColumn(int j) {
        return new double[this.darr.rows()];
    }

    @Override
    public IComplexArray copy() {
        return new ComplexDoubleArrayView(this.darr.copy());
    }

    @Override
    public int order() {
        return this.darr.order();
    }

    @Override
    public int rows() {
        return this.darr.rows();
    }

    @Override
    public int columns() {
        return this.darr.columns();
    }

    @Override
    public double[] getArray() {
        return this.darr.getArray();
    }

    @Override
    public double[][] getTable() {
        return this.darr.getTable();
    }

    @Override
    public double[] getRow(int i) {
        return this.darr.getRow(i);
    }

    @Override
    public double[] getColumn(int j) {
        return this.darr.getColumn(j);
    }

    @Override
    public IComplexArray create(int size) {
        return new ComplexDoubleArrayView(this.darr.create(size));
    }

    @Override
    public void set(int i, double re, double im) {
        int cols = this.columns();
        this.darr.set(i / cols, i % cols, re);
        if (im != 0.0) {
            throw new UnsupportedOperationException("No imaginary part supported");
        }
    }

    @Override
    public void set(int i, int j, double re, double im) {
        this.darr.set(i, j, re);
        if (im != 0.0) {
            throw new UnsupportedOperationException("No imaginary part supported");
        }
    }

    @Override
    public IComplexArray create(int rows, int cols) {
        return new ComplexDoubleArrayView(this.darr.create(rows, cols));
    }

    @Override
    public boolean isSparse() {
        return this.darr.isSparse();
    }
}

