/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.complex.IComplexArray;
import stallone.complex.io.OutputUtil;

public class DenseAsciiVectorsWriter {
    private List<IComplexArray> vectors;
    private String filename;
    private boolean allPurelyReal;

    public DenseAsciiVectorsWriter(List<IComplexArray> vectors, String filename) {
        this.vectors = vectors;
        this.filename = filename;
        if (vectors.isEmpty()) {
            throw new IllegalArgumentException("List of vectors is empty.");
        }
        boolean first = true;
        int vectorSize = vectors.get(0).size();
        for (IComplexArray v : vectors) {
            if (v.size() == vectorSize) continue;
            throw new IllegalArgumentException("Vector do not all have the same length.");
        }
        this.allPurelyReal = true;
        for (IComplexArray v : vectors) {
            if (v.isReal()) continue;
            this.allPurelyReal = false;
        }
    }

    public void perform() {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(this.filename));
                int rows = this.vectors.get(0).size();
                int cols = this.vectors.size();
                if (this.allPurelyReal) {
                    writer.write("DENSE " + Integer.toString(rows) + " " + Integer.toString(cols));
                } else {
                    writer.write("DENSE COMPLEX " + Integer.toString(rows) + " " + Integer.toString(cols));
                }
                writer.newLine();
                int i = 0;
                while (i < rows) {
                    StringBuilder lineBuilder = new StringBuilder();
                    int j = 0;
                    while (j < cols) {
                        double re = this.vectors.get(j).getRe(i);
                        double im = this.vectors.get(j).getIm(i);
                        lineBuilder.append(OutputUtil.scalarToEasyString(re, im)).append(" ");
                        ++j;
                    }
                    writer.write(lineBuilder.toString());
                    writer.newLine();
                    ++i;
                }
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DenseAsciiVectorsWriter.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    writer.close();
                }
                catch (IOException ex2) {
                    Logger.getLogger(DenseAsciiVectorsWriter.class.getName()).log(Level.SEVERE, null, ex2);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DenseAsciiVectorsWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

