/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.util.Iterator;
import stallone.api.API;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.DataSequenceIterator;
import stallone.datasequence.DataSequencePairIterator;

public class DataArray
implements IDataSequence {
    protected double[] times = null;
    protected IDoubleArray[] data = null;

    public DataArray(int size) {
        this.data = new IDoubleArray[size];
    }

    public DataArray(IDoubleArray[] _data) {
        this.data = _data;
    }

    public DataArray(double[] _times, IDoubleArray[] _data) {
        this.times = _times;
        this.data = _data;
    }

    public DataArray(double[][] _data) {
        this.data = new IDoubleArray[_data.length];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = API.doublesNew.array(_data[i]);
            ++i;
        }
    }

    public DataArray(double[] _times, double[][] _data) {
        this(_data);
        this.times = _times;
    }

    public DataArray(IDoubleArray _data) {
        this(_data.getTable());
    }

    public DataArray(IDoubleArray _times, IDoubleArray _data) {
        this(_times.getArray(), _data.getTable());
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public int dimension() {
        return this.data[0].size();
    }

    @Override
    public IDoubleArray get(int i) {
        return this.data[i];
    }

    @Override
    public IDoubleArray getView(int i) {
        return this.data[i];
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new DataSequenceIterator(this);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataSequencePairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataSequence seq;
            private int spacing = 1;

            public PairIterable(IDataSequence _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataSequencePairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }

    @Override
    public double getTime(int i) {
        if (this.times == null) {
            return i;
        }
        return this.times[i];
    }
}

