/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.io.IOException;
import java.util.Iterator;
import stallone.api.datasequence.IDataInput;
import stallone.api.doubles.IDoubleArray;

class DataInput_SingleDataIterator
implements Iterator<IDoubleArray> {
    protected IDataInput loader;
    protected int itraj = 0;
    protected int iindex = 0;
    private int stepsize = 1;

    public DataInput_SingleDataIterator(IDataInput _loader) {
        this.loader = _loader;
        this.stepsize = 1;
    }

    public DataInput_SingleDataIterator(IDataInput _loader, int _stepsize) {
        this.loader = _loader;
        this.stepsize = _stepsize;
    }

    @Override
    public boolean hasNext() {
        return this.itraj < this.loader.numberOfSequences() - 1 || this.itraj == this.loader.numberOfSequences() - 1 && this.iindex < this.loader.size(this.itraj) - 1;
    }

    @Override
    public IDoubleArray next() {
        IDoubleArray res = null;
        try {
            res = this.loader.get(this.itraj, this.iindex);
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    protected void advance() throws IOException {
        this.iindex += this.stepsize;
        if (this.iindex >= this.loader.size(this.itraj)) {
            ++this.itraj;
            this.iindex = 0;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

