/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.util.Iterator;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.DataSequenceIterator;
import stallone.datasequence.DataSequencePairIterator;

public class DataSequenceSkipTimeColumn
implements IDataSequence {
    private IDataSequence seq;
    private int[] selectedRows;
    private int[] selectedColumns;

    private IDoubleArray getDataView(IDoubleArray in) {
        IDoubleArray view = in.view(this.selectedRows, this.selectedColumns);
        return view;
    }

    public DataSequenceSkipTimeColumn(IDataSequence seq) {
        this.seq = seq;
        int dim = seq.dimension();
        int[] selCols = new int[dim - 1];
        this.selectedRows = new int[1];
        int i = 0;
        while (i < selCols.length) {
            selCols[i] = i + 1;
            ++i;
        }
        this.selectedColumns = selCols;
    }

    @Override
    public int size() {
        return this.seq.size();
    }

    @Override
    public int dimension() {
        return this.seq.dimension() - 1;
    }

    @Override
    public double getTime(int i) {
        return this.seq.getTime(i);
    }

    @Override
    public IDoubleArray get(int i) {
        return this.getDataView(this.seq.get(i));
    }

    @Override
    public IDoubleArray getView(int i) {
        return this.getDataView(this.seq.getView(i));
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return new DataSequenceIterator(this);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataSequencePairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataSequence seq;
            private int spacing = 1;

            public PairIterable(IDataSequence _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataSequencePairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }
}

