/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import stallone.api.datasequence.IDataWriter;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;

public class AsciiDataSequenceWriter
implements IDataWriter {
    private boolean fixedPrecision = false;
    private int predigits = 5;
    private int postdigits = 5;
    private String filename;
    private PrintStream out;
    private double currentTime;
    private String dataDelimiter = " ";
    private String datasetDelimiter = "\n";

    public AsciiDataSequenceWriter(String filename) throws FileNotFoundException {
        this.filename = filename;
        this.out = new PrintStream(filename);
        this.currentTime = 0.0;
    }

    public AsciiDataSequenceWriter(PrintStream _out) {
        this.filename = this.filename;
        this.out = _out;
        this.currentTime = 0.0;
    }

    public void setOutputDelimiters(String _dataDelimiter, String _datasetDelimiter) {
        this.dataDelimiter = _dataDelimiter;
        this.datasetDelimiter = _datasetDelimiter;
    }

    public void setFixedPrecision(int pre, int post) {
        this.fixedPrecision = true;
        this.predigits = pre;
        this.postdigits = post;
    }

    @Override
    public void add(IDoubleArray data) {
        String strout = this.fixedPrecision ? Doubles.util.toString(data, this.dataDelimiter, this.dataDelimiter, this.predigits, this.postdigits) : Doubles.util.toString(data, this.dataDelimiter, this.dataDelimiter);
        this.out.print(String.valueOf(strout) + this.datasetDelimiter);
    }

    @Override
    public void addAll(Iterable<IDoubleArray> data) {
        for (IDoubleArray arr : data) {
            this.add(arr);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

