/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.doubles.AbstractDoubleArray;
import stallone.doubles.ArrayIndexMap;
import stallone.doubles.IArrayIndexMap;
import stallone.ints.PrimitiveIntArray;

public class DoubleArrayView
extends AbstractDoubleArray {
    protected IDoubleArray data;
    protected IArrayIndexMap map;

    public DoubleArrayView(IDoubleArray _data, int _top, int _left, int _bottom, int _right) {
        this.data = _data;
        this.map = ArrayIndexMap.createMap(this.data, _top, _left, _bottom, _right);
    }

    public DoubleArrayView(IDoubleArray _data, int _from, int _to) {
        this.data = _data;
        this.map = ArrayIndexMap.createMap(this.data, _from, _to);
    }

    public DoubleArrayView(IDoubleArray _data, int[] rowIndexes, int[] colIndexes) {
        this.data = _data;
        this.map = ArrayIndexMap.createMap(this.data, new PrimitiveIntArray(rowIndexes), new PrimitiveIntArray(colIndexes));
    }

    public DoubleArrayView(IDoubleArray _data, IIntArray rowIndexes, IIntArray colIndexes) {
        this.data = _data;
        this.map = ArrayIndexMap.createMap(this.data, rowIndexes, colIndexes);
    }

    public DoubleArrayView(IDoubleArray _data, int[] indexes) {
        this.data = _data;
        this.map = ArrayIndexMap.createMap(this.data, new PrimitiveIntArray(indexes));
    }

    public DoubleArrayView(IDoubleArray _data, IIntArray indexes) {
        this.data = _data;
        this.map = ArrayIndexMap.createMap(this.data, indexes);
    }

    @Override
    public int rows() {
        return this.map.rows();
    }

    @Override
    public int columns() {
        return this.map.columns();
    }

    @Override
    public double get(int i, int j) {
        int imap = this.map.getRow(i);
        int jmap = this.map.getColumn(j);
        return this.data.get(imap, jmap);
    }

    @Override
    public void set(int i, int j, double x) {
        this.data.set(this.map.getRow(i), this.map.getColumn(j), x);
    }

    @Override
    public IDoubleArray copy() {
        IDoubleArray res = this.data.create(this.map.rows(), this.map.columns());
        this.copyInto(res);
        return res;
    }

    @Override
    public IDoubleArray create(int size) {
        return this.data.create(size);
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        return this.data.create(rows, columns);
    }

    @Override
    public boolean isSparse() {
        return this.data.isSparse();
    }
}

