/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleElement;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleArrayElement;
import stallone.doubles.SparseVectorIndexMap;

public class SparseVectorNonzeroIterator
implements IDoubleIterator {
    protected IDoubleArray x;
    private SparseVectorIndexMap map;
    protected int nonZeroSize;
    protected int i = 0;
    private DoubleArrayElement o;

    public SparseVectorNonzeroIterator(IDoubleArray _x, SparseVectorIndexMap _map) {
        this.x = _x;
        this.map = _map;
        this.nonZeroSize = this.map.usedNonZero;
        this.o = new DoubleArrayElement(_x);
    }

    @Override
    public void reset() {
        this.i = 0;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.nonZeroSize;
    }

    @Override
    public void advance() {
        ++this.i;
    }

    @Override
    public int getIndex() {
        return this.map.nonZeroIndices[this.i];
    }

    @Override
    public double get() {
        return this.x.get(this.map.nonZeroIndices[this.i]);
    }

    @Override
    public void set(double newValue) {
        this.x.set(this.map.nonZeroIndices[this.i], newValue);
    }

    @Override
    public IDoubleElement next() {
        this.o.setIndex(this.getIndex());
        double y = this.get();
        ++this.i;
        return this.o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public int row() {
        if (this.x.rows() == 1) {
            return 0;
        }
        return this.getIndex();
    }

    @Override
    public int column() {
        if (this.x.columns() == 1) {
            return 0;
        }
        return this.getIndex();
    }
}

