/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.io;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;

public class MatrixMarketReader {
    private MatrixMarketReader() {
    }

    public static IDoubleArray read(String filename) throws IOException {
        FileInputStream s = new FileInputStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(s));
        String line = br.readLine();
        boolean comment = true;
        while (comment) {
            line = br.readLine();
            comment = line.startsWith("%");
        }
        String[] str = line.split("( )+");
        int nRows = Integer.valueOf(str[0].trim());
        int nColumns = Integer.valueOf(str[1].trim());
        IDoubleArray matrix = API.doublesNew.sparseMatrix(nRows, nColumns);
        while ((line = br.readLine()) != null) {
            str = line.split("( )+");
            int i = Integer.valueOf(str[0].trim());
            int j = Integer.valueOf(str[1].trim());
            double x = str.length < 3 ? 1.0 : Double.valueOf(str[2].trim());
            matrix.set(i - 1, j - 1, x);
        }
        br.close();
        return matrix;
    }
}

