/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.mtj;

import no.uib.cipr.matrix.Matrix;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;

public class WrappedMTJMatrix
extends AbstractDoubleArray {
    private Matrix mtjMatrix;
    private int rows;
    private int cols;

    public WrappedMTJMatrix(Matrix mtjMatrix) {
        this.rows = mtjMatrix.numRows();
        this.cols = mtjMatrix.numColumns();
        this.mtjMatrix = mtjMatrix;
    }

    @Override
    public double get(int i, int j) {
        return this.mtjMatrix.get(i, j);
    }

    @Override
    public void set(int i, int j, double x) {
        this.mtjMatrix.set(i, j, x);
    }

    @Override
    public void zero() {
        this.mtjMatrix.zero();
    }

    @Override
    public IDoubleArray create(int rows, int cols) {
        throw new UnsupportedOperationException("Cannot copy a wrapped MTJ matrix.");
    }

    @Override
    public IDoubleArray create(int size) {
        throw new UnsupportedOperationException("Matrix create with single size variable not supported.");
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public IDoubleArray copy() {
        IDoubleArray res = API.doublesNew.matrix(this.rows, this.cols);
        res.copyFrom(this);
        return res;
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

