/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.mtj;

import no.uib.cipr.matrix.Vector;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;
import stallone.doubles.DoubleArrayTest;

public class WrappedMTJVector
extends AbstractDoubleArray {
    private Vector mtjVector;
    private int size;

    public WrappedMTJVector(Vector mtjVector) {
        this.size = mtjVector.size();
        this.mtjVector = mtjVector;
    }

    @Override
    public double get(int i) {
        return this.mtjVector.get(i);
    }

    @Override
    public double get(int i, int j) {
        DoubleArrayTest.assertColumnExists(this, j);
        return this.mtjVector.get(i);
    }

    @Override
    public void set(int i, double x) {
        this.mtjVector.set(i, x);
    }

    @Override
    public void set(int i, int j, double x) {
        DoubleArrayTest.assertColumnExists(this, j);
        this.mtjVector.set(i, x);
    }

    @Override
    public void zero() {
        this.mtjVector.zero();
    }

    @Override
    public IDoubleArray create(int size) {
        throw new UnsupportedOperationException("Cannot create a wrapped MTJ matrix.");
    }

    @Override
    public IDoubleArray create(int rows, int cols) {
        throw new UnsupportedOperationException("Cannot create a wrapped MTJ matrix.");
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public IDoubleArray copy() {
        IDoubleArray res = API.doublesNew.array(this.size);
        res.copyFrom(this);
        return res;
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

