/*
 * Decompiled with CFR 0.152.
 */
package stallone.dynamics;

import java.util.Random;
import stallone.api.doubles.IDoubleArray;
import stallone.api.dynamics.IIntegrator;
import stallone.api.dynamics.IIntegratorThermostatted;
import stallone.api.potential.IEnergyModel;

public class LangevinLeapFrog
implements IIntegratorThermostatted {
    private Random random = new Random();
    private IEnergyModel model;
    private double dt;
    private double gamma;
    private double kT;
    private IDoubleArray x;
    private IDoubleArray v;
    private IDoubleArray a;
    private IDoubleArray grad;
    private IDoubleArray rand;
    private IDoubleArray masses;
    private int failsafe = 0;
    private int failures = 0;
    private IDoubleArray xBackup = null;
    private IDoubleArray vBackup = null;

    public LangevinLeapFrog(double _dt, double _gamma, double _kT) {
        this.dt = _dt;
        this.gamma = _gamma;
        this.kT = _kT;
    }

    @Override
    public IIntegrator copy() {
        LangevinLeapFrog res = new LangevinLeapFrog(this.dt, this.gamma, this.kT);
        res.setEnergyModel(this.model);
        res.setFailsafe(this.failures);
        res.setMasses(this.masses.copy());
        res.setV(this.v.copy());
        return res;
    }

    public void setFailsafe(int level) {
        this.failsafe = level;
    }

    @Override
    public void setX(IDoubleArray x0) {
        this.x = x0;
    }

    @Override
    public void setV(IDoubleArray v0) {
        this.v = v0;
    }

    @Override
    public void setEnergyModel(IEnergyModel _model) {
        this.model = _model;
    }

    @Override
    public void setMasses(IDoubleArray _masses) {
        this.masses = _masses;
    }

    @Override
    public void setStepLength(double _dt) {
        this.dt = _dt;
    }

    @Override
    public boolean step() {
        int i;
        double ca = Math.exp(-this.gamma * this.dt / 2.0);
        double cb = (1.0 - ca) / (this.gamma * this.dt);
        double cc = Math.sqrt(1.0 - ca);
        if (this.grad == null) {
            this.model.setCoordinates(this.x);
            this.model.calculate();
            this.grad = this.model.getGradient();
            this.rand = this.x.copy();
            int i2 = 0;
            while (i2 < this.rand.size()) {
                this.rand.set(i2, Math.sqrt(this.kT) * this.random.nextGaussian());
                ++i2;
            }
        }
        if (this.failsafe > 0) {
            this.xBackup = this.x.copy();
            this.vBackup = this.v.copy();
        }
        int attempts = 0;
        boolean success = false;
        while (!success && attempts <= this.failsafe) {
            i = 0;
            while (i < this.v.size()) {
                this.v.set(i, ca * this.v.get(i) - cb * this.dt * this.grad.get(i) / this.masses.get(i) + cc * this.rand.get(i) / Math.sqrt(this.masses.get(i)));
                this.x.set(i, this.x.get(i) + this.dt * this.v.get(i));
                ++i;
            }
            this.model.setCoordinates(this.x);
            success = this.model.calculate();
            if (success || ++attempts > this.failsafe) continue;
            System.out.println(" WARNING: Energy or gradient calculation has failed " + attempts + " times. Failsafe-Level allows for another attempt");
        }
        if (!success) {
            System.out.println(" WARNING: Energy or gradient calculation has failed. Giving up.");
            return false;
        }
        this.grad = this.model.getGradient();
        i = 0;
        while (i < this.v.size()) {
            this.rand.set(i, Math.sqrt(this.kT) * this.random.nextGaussian());
            this.v.set(i, ca * this.v.get(i) - cb * this.dt * this.grad.get(i) / this.masses.get(i) + cc * this.rand.get(i) / Math.sqrt(this.masses.get(i)));
            ++i;
        }
        return true;
    }

    @Override
    public IDoubleArray getX() {
        return this.x;
    }

    @Override
    public IDoubleArray getV() {
        return this.v;
    }

    @Override
    public IDoubleArray getA() {
        return this.a;
    }

    @Override
    public double getStepLength() {
        return this.dt;
    }

    @Override
    public double potentialEnergy() {
        return this.model.getEnergy();
    }

    @Override
    public double kineticEnergy() {
        double ekin = 0.0;
        int i = 0;
        while (i < this.masses.size()) {
            ekin += 0.5 * this.masses.get(i) * this.v.get(i) * this.v.get(i);
            ++i;
        }
        return ekin;
    }

    @Override
    public double totalEnergy() {
        return this.model.getEnergy() + this.kineticEnergy();
    }

    @Override
    public void setkT(double _kT) {
        this.kT = _kT;
    }

    @Override
    public double getkT() {
        return this.kT;
    }
}

