/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import java.util.List;
import stallone.api.datasequence.IDataSequence;
import stallone.api.function.IParametricFunction;
import stallone.api.hmm.HMM;
import stallone.api.hmm.IHMM;
import stallone.api.hmm.IHMMOptimizer;
import stallone.api.hmm.IHMMParameters;
import stallone.api.hmm.ParameterEstimationException;
import stallone.api.stat.IParameterEstimator;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;

public class EMHierarchical
implements IHMMOptimizer {
    private List<IDataSequence> obs;
    private IParametricFunction outputModel;
    private IParameterEstimator outputEstimator;
    private int nstates;
    private IHMMParameters[] parameters;
    private int nsteps;
    private double dectol;
    private IHMM hmmBest = null;

    public EMHierarchical(List<IDataSequence> _obs, IParametricFunction _outputModel, IParameterEstimator _outputEstimator) {
        this.obs = _obs;
        this.outputModel = _outputModel;
        this.outputEstimator = _outputEstimator;
    }

    public void setInitialParameters(IHMMParameters[] _parameters) {
        this.parameters = _parameters;
    }

    public void setInitialNumberOfSteps(int n) {
        this.nsteps = n;
    }

    public void setLikelihoodDecreaseTolerance(double tol) {
        this.dectol = tol;
    }

    @Override
    public void run() throws ParameterEstimationException {
        double[] likelihoods = new double[this.parameters.length];
        IHMMOptimizer emlast = null;
        int level = 1;
        int totaloptsteps = 0;
        while (true) {
            int optsteps = this.nsteps;
            if (level > 1) {
                optsteps = (int)Math.pow(this.nsteps, level - 1);
            }
            System.out.println("#level " + level);
            int i = 0;
            while (i < likelihoods.length) {
                System.out.println("# replica " + (i + 1));
                emlast = HMM.create.em(this.obs, this.outputModel, this.outputEstimator, this.parameters[i]);
                double[] likelihoodsRep = null;
                try {
                    emlast.setMaximumNumberOfStep(optsteps);
                    emlast.setLikelihoodDecreaseTolerance(this.dectol);
                    emlast.run();
                    likelihoodsRep = emlast.getLogLikelihoodHistory();
                    likelihoods[i] = likelihoodsRep[likelihoodsRep.length - 1];
                    this.parameters[i] = emlast.getHMM().getParameters().copy();
                    int k = 0;
                    while (k < likelihoodsRep.length) {
                        System.out.println(String.valueOf(totaloptsteps + k + 1) + "\t" + likelihoodsRep[k]);
                        ++k;
                    }
                }
                catch (ParameterEstimationException e) {
                    System.out.println(" CAUGHT exception in EMHierarchical (see below). Will continue with another try\n" + e);
                }
                Runtime.getRuntime().gc();
                ++i;
            }
            totaloptsteps += optsteps;
            if (this.parameters.length == 1) break;
            int[] SI = PrimitiveIntTools.mirror(PrimitiveDoubleTools.sortedIndexes(likelihoods));
            double[] newlikelihoods = new double[likelihoods.length / 2];
            IHMMParameters[] newparameters = new IHMMParameters[newlikelihoods.length];
            int i2 = 0;
            while (i2 < newlikelihoods.length) {
                newlikelihoods[i2] = likelihoods[SI[i2]];
                newparameters[i2] = this.parameters[SI[i2]];
                ++i2;
            }
            likelihoods = newlikelihoods;
            this.parameters = newparameters;
            ++level;
        }
        this.hmmBest = emlast.getHMM();
    }

    @Override
    public IHMM getHMM() {
        return this.hmmBest;
    }
}

