/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.util.ArrayList;
import stallone.api.API;
import stallone.api.cluster.IClustering;
import stallone.api.datasequence.IDataSequence;
import stallone.api.discretization.IDiscretization;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IMetric;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.datasequence.DataSequenceSubset;
import stallone.ints.PrimitiveIntTools;

public class MultiClustering {
    private IDataSequence data;
    private IMetric metric;
    private IClustering clusterMethodLeaves;
    private IIntArray micro2macro;
    private ArrayList<Leaf> leaves = new ArrayList();

    public MultiClustering(IDataSequence _data, IClustering _clusterMethodFull, IClustering _clusterMethodLeaves) {
        this.data = _data;
        this.clusterMethodLeaves = _clusterMethodLeaves;
        _clusterMethodFull.setInput(_data);
        _clusterMethodFull.perform();
        IDataSequence centers = _clusterMethodFull.getClusterCenters();
        IDiscretization assignment = _clusterMethodFull.getClusterAssignment();
        this.micro2macro = API.cluster.discretize(this.data, assignment);
        int nClusters = _clusterMethodFull.getNumberOfClusters();
        int i = 0;
        while (i < nClusters) {
            IDoubleArray leafCenter = centers.get(i);
            IIntList leafIndexes = API.ints.findAll(this.micro2macro, i);
            this.leaves.add(new Leaf(leafCenter, leafIndexes));
            ++i;
        }
    }

    public MultiClustering(IDataSequence _data, IDataSequence _initcenters, IMetric _metric, IClustering _clusterMethodLeaves) {
        this.data = _data;
        this.clusterMethodLeaves = _clusterMethodLeaves;
        this.metric = _metric;
        IDiscretization voronoiDiscretization = API.discNew.voronoiDiscretization(_initcenters, _metric);
        this.micro2macro = API.cluster.discretize(_data, voronoiDiscretization);
        int nInitialClusters = _initcenters.size();
        IIntList[] leafIndexes = new IIntList[nInitialClusters];
        int i = 0;
        while (i < leafIndexes.length) {
            leafIndexes[i] = API.intsNew.list(0);
            ++i;
        }
        i = 0;
        while (i < this.micro2macro.size()) {
            int s = this.micro2macro.get(i);
            leafIndexes[s].append(i);
            ++i;
        }
        i = 0;
        while (i < leafIndexes.length) {
            this.leaves.add(new Leaf(_initcenters.get(i), leafIndexes[i]));
            ++i;
        }
    }

    public boolean split(int leafIndex) {
        int nClustersBeforeSplitting = this.leaves.size();
        Leaf leaf = this.leaves.get(leafIndex);
        DataSequenceSubset subset = new DataSequenceSubset(this.data, leaf.indexes);
        this.clusterMethodLeaves.setInput(subset);
        this.clusterMethodLeaves.perform();
        int nPieces = this.clusterMethodLeaves.getNumberOfClusters();
        if (nPieces == 1) {
            return false;
        }
        int[] reassign = new int[this.clusterMethodLeaves.getNumberOfClusters()];
        reassign[0] = leafIndex;
        int i = 1;
        while (i < reassign.length) {
            reassign[i] = nClustersBeforeSplitting + (i - 1);
            ++i;
        }
        IDiscretization assignment = this.clusterMethodLeaves.getClusterAssignment();
        IDataSequence centers = this.clusterMethodLeaves.getClusterCenters();
        IIntArray micro2macroLeaf = API.cluster.discretize(subset, assignment);
        int i2 = 0;
        while (i2 < leaf.indexes.size()) {
            int globalIndex = leaf.indexes.get(i2);
            int newClusterIndex = reassign[micro2macroLeaf.get(i2)];
            this.micro2macro.set(globalIndex, newClusterIndex);
            ++i2;
        }
        IIntArray[] newLeaveIndexes = new IIntArray[nPieces];
        int i3 = 0;
        while (i3 < nPieces) {
            newLeaveIndexes[i3] = API.ints.findAll(micro2macroLeaf, i3);
            int j = 0;
            while (j < newLeaveIndexes[i3].size()) {
                newLeaveIndexes[i3].set(j, leaf.indexes.get(newLeaveIndexes[i3].get(j)));
                ++j;
            }
            ++i3;
        }
        this.leaves.set(leafIndex, new Leaf(centers.get(0), newLeaveIndexes[0]));
        i3 = 1;
        while (i3 < nPieces) {
            this.leaves.add(new Leaf(centers.get(i3), newLeaveIndexes[i3]));
            ++i3;
        }
        System.out.print(" splitted indexes: " + leafIndex + " -> (" + PrimitiveIntTools.toString(reassign, ",") + ")" + "\n  nstates: " + leaf.indexes.size() + " -> (");
        i3 = 0;
        while (i3 < newLeaveIndexes.length) {
            System.out.print(String.valueOf(newLeaveIndexes[i3].size()) + ",");
            ++i3;
        }
        System.out.println(")\n  now we have " + this.leaves.size() + " states");
        return true;
    }

    public boolean split(IIntArray leafIndexes) {
        boolean couldsplit = false;
        IIntArray I = API.ints.sortedIndexes(leafIndexes);
        int i = I.size() - 1;
        while (i >= 0) {
            int splitIndex = leafIndexes.get(I.get(i));
            if (this.split(splitIndex)) {
                couldsplit = true;
            }
            --i;
        }
        return couldsplit;
    }

    public ArrayList<IIntArray> getLeafIndexes() {
        ArrayList<IIntArray> res = new ArrayList<IIntArray>();
        for (Leaf l : this.leaves) {
            res.add(l.indexes);
        }
        return res;
    }

    public ArrayList<IDoubleArray> getLeafCenters() {
        ArrayList<IDoubleArray> res = new ArrayList<IDoubleArray>();
        for (Leaf l : this.leaves) {
            res.add(l.center);
        }
        return res;
    }

    public IIntArray getDiscreteTrajectory() {
        return this.micro2macro;
    }

    class Leaf {
        public IDoubleArray center;
        public IIntArray indexes;

        public Leaf(IDoubleArray _center, IIntArray _indexes) {
            this.center = _center;
            this.indexes = _indexes;
        }
    }
}

