/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.hmm.ParameterEstimationException;
import stallone.api.ints.IIntArray;
import stallone.hmm.pmm.NinjaEstimator;
import stallone.util.CommandLineParser;

public class NinjaEstimatorTestConvergence {
    private List<String> inputFiles;
    private List<IIntArray> discreteTrajectories;
    private int nhidden;
    private int tau = 1;
    private int timeshift = 1;
    private int[] nHMMConv = new int[]{1, 2, 3, 4, 5, 7, 9, 11, 13, 15, 18, 21, 24, 27, 30, 35, 40, 45, 50, 60, 70, 80, 90, 100, 120, 140, 160, 180, 200, 250, 300, 350, 400, 450, 500, 600, 700, 800, 900, 1000};
    private String outfile;
    private NinjaEstimator ninja;

    public boolean parseArguments(String[] args) throws FileNotFoundException, IOException {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringArrayCommand("i", true);
        parser.addIntCommand("nhidden", true);
        parser.addIntArrayCommand("nhmmconv", false);
        parser.addCommand("estimate", false);
        parser.addIntArgument("estimate", true);
        parser.addIntArgument("estimate", true);
        parser.addStringCommand("o", true);
        if (!parser.parse(args)) {
            return false;
        }
        String[] ifiles = parser.getStringArray("i");
        this.inputFiles = new ArrayList<String>();
        int i = 0;
        while (i < ifiles.length) {
            this.inputFiles.add(ifiles[i]);
            ++i;
        }
        this.discreteTrajectories = API.intseqNew.intSequenceLoader(this.inputFiles).loadAll();
        this.nhidden = parser.getInt("nhidden");
        if (parser.hasCommand("nhmmconv")) {
            this.nHMMConv = parser.getIntArray("nhmmconv");
        }
        if (parser.hasCommand("estimate")) {
            this.tau = parser.getInt("estimate", 0);
            this.timeshift = parser.getInt("estimate", 1);
        }
        this.outfile = parser.getString("o");
        return true;
    }

    public static String getUsageString() {
        return "\n=======================================\n NinjaEstimatorTestConvergence\n=======================================\nUsage: \n\nMandatory input and output options: \n -i <discrete trajectory>+\n -nhidden <number of hidden states>\n -nhmmconv <sequence of convergence steps>\n\n -o <out-file>\n\n -estimate <tau> <timeshift>\n\n";
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, ParameterEstimationException {
        NinjaEstimatorTestConvergence cmd;
        if (args.length == 0) {
            System.out.println(NinjaEstimatorTestConvergence.getUsageString());
            System.exit(0);
        }
        if (!(cmd = new NinjaEstimatorTestConvergence()).parseArguments(args)) {
            System.out.println(NinjaEstimatorTestConvergence.getUsageString());
            System.exit(0);
        }
        cmd.ninja = new NinjaEstimator(cmd.discreteTrajectories);
        cmd.ninja.setNHiddenStates(cmd.nhidden);
        cmd.ninja.setTau(cmd.tau);
        cmd.ninja.setTimeshift(cmd.timeshift);
        cmd.ninja.setHMMLikelihoodMaxIncrease(10.0);
        PrintStream out = new PrintStream(cmd.outfile);
        int i = 0;
        while (i < cmd.nHMMConv.length) {
            int nconv = cmd.nHMMConv[i];
            cmd.ninja.setNIterHMMMax(nconv);
            cmd.ninja.estimate();
            IDoubleArray hmmTimescales = cmd.ninja.getHMMTimescales();
            double[] hmmLikelihoodHistory = cmd.ninja.getHMMLikelihoodHistory();
            double lastLikelihood = hmmLikelihoodHistory[hmmLikelihoodHistory.length - 1];
            out.println(String.valueOf(nconv) + "\t" + lastLikelihood + "\t" + API.doubles.toString(hmmTimescales));
            ++i;
        }
    }
}

