/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntElement;
import stallone.api.ints.IIntIterator;
import stallone.ints.IntTableElement;

public class IntTableIterator
implements IIntIterator {
    protected IIntArray X;
    protected int i = 0;
    protected int j = 0;
    protected int rows;
    protected int cols;

    public IntTableIterator(IIntArray _X) {
        this.X = _X;
        this.rows = this.X.rows();
        this.cols = this.X.columns();
    }

    @Override
    public void reset() {
        this.i = 0;
        this.j = 0;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.cols && this.j < this.rows;
    }

    @Override
    public int row() {
        return this.i;
    }

    @Override
    public int column() {
        return this.j;
    }

    @Override
    public void advance() {
        ++this.j;
        if (this.j == this.cols) {
            ++this.i;
            this.j = 0;
        }
    }

    @Override
    public int get() {
        return this.X.get(this.i, this.j);
    }

    @Override
    public void set(int newValue) {
        this.X.set(this.i, this.j, newValue);
    }

    @Override
    public IIntElement next() {
        return new IntTableElement(this.X, this.i, this.j);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public int getIndex() {
        return this.i * this.cols + this.j;
    }
}

