/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import java.util.Arrays;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.api.ints.Ints;
import stallone.ints.IntArrayIterator;
import stallone.ints.IntArrayNonzeroIterator;
import stallone.ints.IntArrayView;
import stallone.ints.PrimitiveIntTable;
import stallone.ints.PrimitiveIntTools;

public class PrimitiveIntArray
implements IIntArray {
    protected int[] x;

    public PrimitiveIntArray(int n) {
        this.x = new int[n];
    }

    public PrimitiveIntArray(int[] _x) {
        this.x = _x;
    }

    @Override
    public int get(int i) {
        return this.x[i];
    }

    @Override
    public void set(int i, int v) {
        this.x[i] = v;
    }

    @Override
    public int[] getArray() {
        return this.x;
    }

    @Override
    public int size() {
        return this.x.length;
    }

    @Override
    public IIntArray copy() {
        int[] xcopy = Arrays.copyOf(this.x, this.x.length);
        return new PrimitiveIntArray(xcopy);
    }

    @Override
    public IIntArray create(int size) {
        return new PrimitiveIntArray(new int[size]);
    }

    @Override
    public IIntIterator iterator() {
        return new IntArrayIterator(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IIntArray)) {
            return false;
        }
        IIntArray oo = (IIntArray)o;
        int i = 0;
        while (i < oo.size()) {
            if (oo.get(i) != this.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return PrimitiveIntTools.toString(this.x);
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public int rows() {
        return this.x.length;
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public int get(int i, int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        return this.x[i];
    }

    @Override
    public void set(int i, int j, int _x) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        this.x[i] = _x;
    }

    @Override
    public int[][] getTable() {
        int[][] res = new int[this.size()][1];
        int i = 0;
        while (i < res.length) {
            res[i][0] = this.x[i];
            ++i;
        }
        return res;
    }

    @Override
    public int[] getRow(int i) {
        return new int[]{this.x[i]};
    }

    @Override
    public int[] getColumn(int j) {
        return this.x;
    }

    @Override
    public IIntIterator nonzeroIterator() {
        return new IntArrayNonzeroIterator(this);
    }

    @Override
    public void copyInto(IIntArray other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException("Incompatible sizes. This array has size " + this.size() + ", the other array has size " + other.size());
        }
        Ints.util.copyInto(this, 0, this.size(), other, 0);
    }

    @Override
    public IIntArray create(int rows, int columns) {
        return new PrimitiveIntTable(rows, columns);
    }

    @Override
    public IIntArray viewRow(int i) {
        return new IntArrayView(this, i, 0, i + 1, 1);
    }

    @Override
    public IIntArray viewColumn(int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a column array. Column index " + j + " does not exist!");
        }
        return this;
    }

    @Override
    public void copyFrom(IIntArray other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException("Incompatible sizes. This array has size " + this.size() + ", the other array has size " + other.size());
        }
        Ints.util.copyInto(other, 0, this.size(), this, 0);
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

