/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.api.ints.Ints;
import stallone.ints.IntArrayView;
import stallone.ints.IntTableIterator;
import stallone.ints.IntTableNonzeroIterator;
import stallone.ints.PrimitiveIntTools;

public class PrimitiveIntTable
implements IIntArray {
    protected int[][] x;
    private int ndim = 3;
    private IntArrayView rowview = null;
    private IntArrayView colview = null;

    public PrimitiveIntTable(int[][] _x) {
        this.x = _x;
        this.ndim = this.x[0].length;
        int i = 1;
        while (i < _x.length) {
            if (_x[i].length != this.ndim) {
                throw new IllegalArgumentException("Trying to construct DoubleTable with ragged array. Only rectangular arrays are permitted.");
            }
            ++i;
        }
    }

    public PrimitiveIntTable(int rows, int cols) {
        this(new int[rows][cols]);
    }

    @Override
    public int get(int row, int col) {
        return this.x[row][col];
    }

    @Override
    public void set(int row, int col, int val) {
        this.x[row][col] = val;
    }

    @Override
    public void copyFrom(IIntArray other) {
        int size = other.size();
        if (size != this.size()) {
            throw new IllegalArgumentException("Trying to copy from array with different size");
        }
        int i = 0;
        while (i < size) {
            this.set(i, other.get(i));
            ++i;
        }
    }

    @Override
    public int get(int i) {
        int row = i / this.ndim;
        int col = i % this.ndim;
        return this.x[row][col];
    }

    @Override
    public void set(int i, int v) {
        int row = i / this.ndim;
        int col = i % this.ndim;
        this.x[row][col] = v;
    }

    @Override
    public int[] getArray() {
        return PrimitiveIntTools.flatten(this.x);
    }

    @Override
    public int[][] getTable() {
        return this.x;
    }

    @Override
    public int size() {
        return this.x.length * this.x[0].length;
    }

    @Override
    public int rows() {
        return this.x.length;
    }

    @Override
    public int columns() {
        return this.x[0].length;
    }

    @Override
    public IIntArray copy() {
        return new PrimitiveIntTable(PrimitiveIntTools.copy(this.x));
    }

    @Override
    public IIntArray create(int size) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public IIntArray create(int rows, int cols) {
        return new PrimitiveIntTable(rows, cols);
    }

    @Override
    public IIntIterator iterator() {
        return new IntTableIterator(this);
    }

    @Override
    public int[] getRow(int i) {
        return this.x[i];
    }

    @Override
    public int[] getColumn(int i) {
        return PrimitiveIntTools.getColumn(this.x, i);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IIntArray)) {
            return false;
        }
        IIntArray oo = (IIntArray)o;
        int i = 0;
        while (i < oo.size()) {
            if (oo.get(i) != this.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return Ints.util.toString(this);
    }

    @Override
    public IIntArray viewRow(int i) {
        if (this.rowview == null) {
            this.rowview = new IntArrayView(this, i, 0, i + 1, this.columns());
            return this.rowview;
        }
        this.rowview.setView(i, 0, i + 1, this.columns());
        return this.rowview;
    }

    @Override
    public IIntArray viewColumn(int j) {
        if (this.colview == null) {
            this.colview = new IntArrayView(this, 0, j, this.rows(), j + 1);
            return this.colview;
        }
        this.colview.setView(0, j, this.rows(), j + 1);
        return this.colview;
    }

    @Override
    public int order() {
        return 2;
    }

    @Override
    public IIntIterator nonzeroIterator() {
        return new IntTableNonzeroIterator(this);
    }

    @Override
    public void copyInto(IIntArray other) {
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Inconsistent sizes. This array has size " + this.size() + " other array has size " + other.size());
        }
        Ints.util.copyInto(this, 0, this.size(), other, 0);
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

