/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import stallone.doubles.PrimitiveDoubleTools;

public class PrimitiveIntTools {
    public static int[] createInitialized(int size, int d) {
        int[] res = new int[size];
        Arrays.fill(res, d);
        return res;
    }

    public static int[] getIntArray(int ... d) {
        int[] arr = new int[d.length];
        System.arraycopy(d, 0, arr, 0, d.length);
        return arr;
    }

    public static int[] from(double[] a) {
        int[] res = new int[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = (int)a[i];
            ++i;
        }
        return res;
    }

    public static int[][] from(double[][] a) {
        int[][] res = new int[a.length][];
        int i = 0;
        while (i < a.length) {
            res[i] = PrimitiveIntTools.from(a[i]);
            ++i;
        }
        return res;
    }

    public static int[] from(float[] a) {
        int[] res = new int[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = (int)a[i];
            ++i;
        }
        return res;
    }

    public static int[][] from(float[][] a) {
        int[][] res = new int[a.length][];
        int i = 0;
        while (i < a.length) {
            res[i] = PrimitiveIntTools.from(a[i]);
            ++i;
        }
        return res;
    }

    public static int[][] alloc(int[][] arr) {
        int[][] res = new int[arr.length][];
        int i = 0;
        while (i < arr.length) {
            res[i] = new int[arr[i].length];
            ++i;
        }
        return res;
    }

    public static int[] lengths(int[][] arr) {
        int[] res = new int[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i].length;
            ++i;
        }
        return res;
    }

    public static void fill(int[][] arr, int v) {
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                arr[i][j] = v;
                ++j;
            }
            ++i;
        }
    }

    public static int[] add(int[] arr1, int v) {
        int[] res = new int[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] + v;
            ++i;
        }
        return res;
    }

    public static int[] add(int[] a1, int[] a2) {
        int[] res = new int[a1.length];
        int i = 0;
        while (i < res.length) {
            res[i] = a1[i] + a2[i];
            ++i;
        }
        return res;
    }

    public static int[][] add(int[][] arr1, int v) {
        int[][] res = new int[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = PrimitiveIntTools.add(arr1[i], v);
            ++i;
        }
        return res;
    }

    public static int[] multiply(int v, int[] arr1) {
        int[] res = new int[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = v * arr1[i];
            ++i;
        }
        return res;
    }

    public static double[] toDouble(int[] arr) {
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    public static double[][] toDouble(int[][] arr) {
        double[][] res = new double[arr.length][];
        int i = 0;
        while (i < arr.length) {
            res[i] = new double[arr[i].length];
            int j = 0;
            while (j < arr[i].length) {
                res[i][j] = arr[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static int[] List2Array(Collection<Integer> al) {
        int size = al.size();
        int[] res = new int[size];
        int k = 0;
        Iterator<Integer> i = al.iterator();
        while (i.hasNext()) {
            res[k++] = i.next();
        }
        return res;
    }

    public static int[][] List2Array2(Collection<?> al) {
        int size = al.size();
        int[][] res = new int[size][];
        int k = 0;
        Iterator<?> i = al.iterator();
        while (i.hasNext()) {
            res[k++] = (int[])i.next();
        }
        return res;
    }

    public static int[][][] List2Array3(Collection<?> al) {
        int size = al.size();
        int[][][] res = new int[size][][];
        int k = 0;
        Iterator<?> i = al.iterator();
        while (i.hasNext()) {
            res[k++] = (int[][])i.next();
        }
        return res;
    }

    public static int[] copy(int[] arr) {
        int[] res = new int[arr.length];
        int j = 0;
        int i = 0;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static int[][] copy(int[][] arr) {
        int[][] res = new int[arr.length][];
        int j = 0;
        int i = 0;
        while (i < arr.length) {
            res[j++] = PrimitiveIntTools.copy(arr[i]);
            ++i;
        }
        return res;
    }

    public static int randomSelection(int[] arr) {
        int i = (int)((double)arr.length * Math.random());
        return arr[i];
    }

    public static int[] randomIndexes(int N, int n) {
        if (n >= N) {
            return PrimitiveIntTools.range(0, N);
        }
        boolean[] included = new boolean[N];
        if ((double)n < 0.5 * (double)N) {
            Arrays.fill(included, false);
            int i = 0;
            while (i < n) {
                int v = (int)((double)N * Math.random());
                if (included[v]) continue;
                included[v] = true;
                ++i;
            }
        } else {
            Arrays.fill(included, true);
            int nExclude = N - n;
            int i = 0;
            while (i < nExclude) {
                int v = (int)((double)N * Math.random());
                if (!included[v]) continue;
                included[v] = false;
                ++i;
            }
        }
        int[] selected = new int[n];
        int k = 0;
        int i = 0;
        while (i < included.length) {
            if (included[i]) {
                selected[k++] = i;
            }
            ++i;
        }
        return selected;
    }

    public static int[] randomSelection(int[] arr, int n) {
        return PrimitiveIntTools.subarray(arr, PrimitiveIntTools.randomIndexes(arr.length, n));
    }

    public static int[] randomPermutation(int[] arr) {
        double[] R = new double[arr.length];
        int i = 0;
        while (i < R.length) {
            R[i] = Math.random();
            ++i;
        }
        int[] I = PrimitiveDoubleTools.sortedIndexes(R);
        int[] res = new int[I.length];
        int i2 = 0;
        while (i2 < res.length) {
            res[i2] = arr[I[i2]];
            ++i2;
        }
        return res;
    }

    public static int[] fromLinkedList(LinkedList<?> ll) {
        int[] res = new int[ll.size()];
        Iterator i = ll.iterator();
        int k = 0;
        while (i.hasNext()) {
            res[k++] = (Integer)i.next();
        }
        return res;
    }

    public static int[] fromBooleanArray(boolean[] ba) {
        int k = 0;
        int i = 0;
        while (i < ba.length) {
            if (ba[i]) {
                ++k;
            }
            ++i;
        }
        int[] res = new int[k];
        k = 0;
        int i2 = 0;
        while (i2 < ba.length) {
            if (ba[i2]) {
                res[k++] = i2;
            }
            ++i2;
        }
        return res;
    }

    public static int[][] reshape(int[] arr, int d1, int d2) {
        if (arr.length != d1 * d2) {
            throw new IllegalArgumentException("Illegal array size");
        }
        int[][] res = new int[d1][d2];
        int i = 0;
        while (i < d1) {
            int j = 0;
            while (j < d2) {
                res[i][j] = arr[i * d2 + j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static int[] flatten(int[][] a) {
        int n = 0;
        int i = 0;
        while (i < a.length) {
            n += a[i].length;
            ++i;
        }
        int[] res = new int[n];
        int i2 = 0;
        int k = 0;
        while (i2 < a.length) {
            int j = 0;
            while (j < a[i2].length) {
                res[k++] = a[i2][j];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static int[] concat(int[] a1, int[] a2) {
        int[] res = new int[a1.length + a2.length];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public static int[][] concat(int[][] a1, int[][] a2) {
        int[][] res = new int[a1.length + a2.length][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public static int[] concat(int[] a1, int a2) {
        int[] res = new int[a1.length + 1];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public static int[][] concat(int[][] a1, int[] a2) {
        int[][] res = new int[a1.length + 1][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public static int[] subarray(int[] a, int i1, int i2) {
        int[] res = new int[i2 - i1];
        int i = i1;
        while (i < i2) {
            res[i - i1] = a[i];
            ++i;
        }
        return res;
    }

    public static int[] subarray(int[] a, int[] sel) {
        int[] res = new int[sel.length];
        int i = 0;
        while (i < sel.length) {
            res[i] = a[sel[i]];
            ++i;
        }
        return res;
    }

    public static int[][] subarray(int[][] a, int i1, int i2) {
        int[][] res = new int[i2 - i1][];
        int i = i1;
        while (i < i2) {
            res[i - i1] = a[i];
            ++i;
        }
        return res;
    }

    public static int[][] subarray(int[][] a, int x1, int x2, int y1, int y2) {
        int[][] res = new int[x2 - x1][y2 - y1];
        int x = x1;
        while (x < x2) {
            int y = y1;
            while (y < y2) {
                res[x - x1][y - y1] = a[x][y];
                ++y;
            }
            ++x;
        }
        return res;
    }

    public static int[][] subarray(int[][] a, int[] sel) {
        int[][] res = new int[sel.length][];
        int i = 0;
        while (i < sel.length) {
            res[i] = a[sel[i]];
            ++i;
        }
        return res;
    }

    public static boolean equal(int[] arr1, int[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (arr1[i] != arr2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] getColumn(int[][] a, int c) {
        int[] res = new int[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i][c];
            ++i;
        }
        return res;
    }

    public static void set(int[] arr, int[] index, int val) {
        int i = 0;
        while (i < index.length) {
            arr[index[i]] = val;
            ++i;
        }
    }

    public static int[] insert(int[] arr, int index, int v) {
        int[] res = new int[arr.length + 1];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        res[j++] = v;
        i = index;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static void insertFixed(int[] arr, int index, int num) {
        if (index < 0 || index > arr.length - 1) {
            throw new ArrayIndexOutOfBoundsException("illegal index " + index);
        }
        int i = arr.length - 1;
        while (i > index) {
            arr[i] = arr[i - 1];
            --i;
        }
        arr[index] = num;
    }

    public static void insertFixed(int[][] arr, int index, int[] num) {
        if (index < 0 || index > arr.length - 1) {
            throw new ArrayIndexOutOfBoundsException("illegal index " + index);
        }
        int i = arr.length - 1;
        while (i > index) {
            arr[i] = arr[i - 1];
            --i;
        }
        arr[index] = num;
    }

    public static int[] append(int[] arr, int v) {
        int[] res = new int[arr.length + 1];
        int j = 0;
        int i = 0;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        res[j++] = v;
        return res;
    }

    public static void exchange(int[] arr, int i, int j) {
        int t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public static int[] removeByIndex(int[] arr, int index) {
        int[] res = new int[arr.length - 1];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        i = index + 1;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static int[] removeByIndex(int[] arr, int[] indexes) {
        boolean[] exclude = new boolean[arr.length];
        int nex = 0;
        int i = 0;
        while (i < indexes.length) {
            if (!exclude[indexes[i]]) {
                exclude[indexes[i]] = true;
                ++nex;
            }
            ++i;
        }
        int[] res = new int[arr.length - nex];
        int j = 0;
        int i2 = 0;
        while (i2 < arr.length) {
            if (!exclude[i2]) {
                res[j++] = arr[i2];
            }
            ++i2;
        }
        return res;
    }

    public static int[][] removeByIndex(int[][] arr, int index) {
        int[][] res = new int[arr.length - 1][];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        i = index + 1;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static int[][] removeByIndex(int[][] arr, int[] indexes) {
        boolean[] exclude = new boolean[arr.length];
        int nex = 0;
        int i = 0;
        while (i < indexes.length) {
            if (!exclude[indexes[i]]) {
                exclude[indexes[i]] = true;
                ++nex;
            }
            ++i;
        }
        int[][] res = new int[arr.length - nex][];
        int j = 0;
        int i2 = 0;
        while (i2 < arr.length) {
            if (!exclude[i2]) {
                res[j++] = arr[i2];
            }
            ++i2;
        }
        return res;
    }

    public static int[] removeByValue(int[] arr1, int[] arr2) {
        int[] res = new int[arr1.length];
        int k = 0;
        int i = 0;
        while (i < arr1.length) {
            boolean cinsert = true;
            int j = 0;
            while (j < arr2.length) {
                if (arr1[i] == arr2[j]) {
                    cinsert = false;
                }
                ++j;
            }
            if (cinsert) {
                res[k++] = arr1[i];
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, k);
    }

    public static int[] removeByValue(int[] arr1, int a2) {
        int[] arr2 = new int[]{a2};
        return PrimitiveIntTools.removeByValue(arr1, arr2);
    }

    public static int[][] removeByValue(int[][] arr1, int[] v) {
        int[][] res = new int[arr1.length][];
        int k = 0;
        int i = 0;
        while (i < arr1.length) {
            if (!PrimitiveIntTools.equal(arr1[i], v)) {
                res[k++] = arr1[i];
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, k);
    }

    public static int[] mirror(int[] arr) {
        int[] res = new int[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[arr.length - 1 - i] = arr[i];
            ++i;
        }
        return res;
    }

    public static int[][] transpose(int[][] arr) {
        int nCol = arr.length;
        int nLin = arr[0].length;
        int i = 0;
        while (i < arr.length) {
            if (arr[i].length != nLin) {
                throw new IllegalArgumentException("Trying to transpose a non-matrix-array");
            }
            ++i;
        }
        int[][] res = new int[nLin][nCol];
        int i2 = 0;
        while (i2 < res.length) {
            int j = 0;
            while (j < res[i2].length) {
                res[i2][j] = arr[j][i2];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static int[] clean(int[] uncleaned) {
        return PrimitiveDoubleTools.toInt(PrimitiveDoubleTools.clean(PrimitiveIntTools.toDouble(uncleaned)));
    }

    public static int count(int[] arr, int val) {
        int c = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == val) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public static int[] histogram(int[] arr, int mi, int ma) {
        int[] res = new int[ma - mi + 1];
        int i = 0;
        while (i < arr.length) {
            int n = arr[i] - mi;
            res[n] = res[n] + 1;
            ++i;
        }
        return res;
    }

    public static int[] histogram(int[] arr) {
        return PrimitiveIntTools.histogram(arr, PrimitiveIntTools.min(arr), PrimitiveIntTools.max(arr));
    }

    public static boolean contains(int[] arr, int val) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsAny(int[] arr, int[] val) {
        int i = 0;
        while (i < val.length) {
            if (PrimitiveIntTools.contains(arr, val[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsAll(int[] arr, int[] val) {
        int i = 0;
        while (i < val.length) {
            if (!PrimitiveIntTools.contains(arr, val[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean contains(int[][] arr, int[] sub) {
        int i = 0;
        while (i < arr.length) {
            if (PrimitiveIntTools.equal(arr[i], sub)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int min(int[] arr) {
        int m = arr[0];
        int i = 1;
        while (i < arr.length) {
            if (arr[i] < m) {
                m = arr[i];
            }
            ++i;
        }
        return m;
    }

    public static int minIndex(int[] arr) {
        int m = arr[0];
        int mi = 0;
        int i = 1;
        while (i < arr.length) {
            if (arr[i] < m) {
                m = arr[i];
                mi = i;
            }
            ++i;
        }
        return mi;
    }

    public static int max(int[] arr) {
        int m = arr[0];
        int i = 1;
        while (i < arr.length) {
            if (arr[i] > m) {
                m = arr[i];
            }
            ++i;
        }
        return m;
    }

    public static int maxIndex(int[] arr) {
        int m = arr[0];
        int mi = 0;
        int i = 1;
        while (i < arr.length) {
            if (arr[i] > m) {
                m = arr[i];
                mi = i;
            }
            ++i;
        }
        return mi;
    }

    public static int sum(int[] arr) {
        int sum = 0;
        int i = 0;
        while (i < arr.length) {
            sum += arr[i];
            ++i;
        }
        return sum;
    }

    public static double mean(int[] arr) {
        return (double)PrimitiveIntTools.sum(arr) / (double)arr.length;
    }

    public static int[] intersect(int[] arr1, int[] arr2) {
        int[] arr1c = PrimitiveIntTools.clean(arr1);
        int[] arr2c = PrimitiveIntTools.clean(arr2);
        int[] res = new int[Math.min(arr1c.length, arr2c.length)];
        int k = 0;
        int k1 = 0;
        int k2 = 0;
        while (k1 < arr1c.length && k2 < arr2c.length) {
            if (arr1c[k1] < arr2c[k2]) {
                ++k1;
            }
            if (k1 < arr1c.length && k2 < arr2c.length && arr1c[k1] == arr2c[k2]) {
                res[k++] = arr1c[k1];
                ++k1;
                ++k2;
            }
            if (k1 >= arr1c.length || k2 >= arr2c.length || arr1c[k1] <= arr2c[k2]) continue;
            ++k2;
        }
        return PrimitiveIntTools.subarray(res, 0, k);
    }

    public static int[] union(int[] arr1, int[] arr2) {
        return PrimitiveIntTools.clean(PrimitiveIntTools.concat(arr1, arr2));
    }

    public static int[] union(int[] arr1, int arr2) {
        return PrimitiveIntTools.clean(PrimitiveIntTools.concat(arr1, arr2));
    }

    public static int findForward(int[] arr, int val, int from) {
        int i = from;
        while (i < arr.length) {
            if (arr[i] == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findForward(int[] arr, int val) {
        return PrimitiveIntTools.findForward(arr, val, 0);
    }

    public static int findBackwards(int[] arr, int val, int from) {
        int i = from;
        while (i >= 0) {
            if (arr[i] == val) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int findBackwards(int[] arr, int val) {
        return PrimitiveIntTools.findBackwards(arr, val, 0);
    }

    public static int[] findAll(int[] arr, int val) {
        LinkedList<Integer> ll = new LinkedList<Integer>();
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == val) {
                ll.add(new Integer(i));
            }
            ++i;
        }
        return PrimitiveIntTools.List2Array(ll);
    }

    public static int[] findAll(int[] arr, int[] val) {
        LinkedList<Integer> ll = new LinkedList<Integer>();
        int i = 0;
        while (i < arr.length) {
            if (PrimitiveIntTools.contains(val, arr[i])) {
                ll.add(new Integer(i));
            }
            ++i;
        }
        return PrimitiveIntTools.List2Array(ll);
    }

    public static int[] sort(int[] arr) {
        double[] darr = PrimitiveIntTools.toDouble(arr);
        PrimitiveDoubleTools.sort(darr);
        return PrimitiveDoubleTools.toInt(darr);
    }

    public static int[] sortedIndexes(int[] arr) {
        return PrimitiveDoubleTools.sortedIndexes(PrimitiveIntTools.toDouble(arr));
    }

    public static int locateSorted(int[] arr, double num) {
        int l = 0;
        int m = arr.length / 2;
        int r = arr.length;
        boolean found = false;
        while (!found) {
            if (num < (double)arr[m]) {
                r = m;
                m = (r + l) / 2;
            } else if (num > (double)arr[m]) {
                l = m;
                m = (r + l) / 2;
            } else {
                found = true;
            }
            if (m != l && m != r) continue;
            found = true;
        }
        found = false;
        while (!found) {
            if (m == 0) {
                found = true;
                continue;
            }
            if (arr[m - 1] != arr[m]) {
                found = true;
                continue;
            }
            --m;
        }
        if (num > (double)arr[m]) {
            ++m;
        }
        return m;
    }

    public static String toString(int[] arr, String del) {
        if (arr == null) {
            return "null";
        }
        StringBuffer strbuf = new StringBuffer(arr.length * 10);
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(arr[i]));
            if (i + 1 < arr.length) {
                strbuf.append(del);
            }
            ++i;
        }
        return strbuf.toString();
    }

    public static String toString(int[] arr) {
        return PrimitiveIntTools.toString(arr, ",");
    }

    public static String toString(int[][] arr, String del1, String del2) {
        if (arr.length == 0) {
            return "";
        }
        StringBuffer strbuf = new StringBuffer(arr.length * arr[0].length * 10);
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(PrimitiveIntTools.toString(arr[i], del1)) + del2);
            ++i;
        }
        return strbuf.toString();
    }

    public static String toString(int[][] arr) {
        return PrimitiveIntTools.toString(arr, ",", "\n");
    }

    public static void print(int[] arr, String del) {
        System.out.println(PrimitiveIntTools.toString(arr, del));
    }

    public static void print(int[] arr) {
        System.out.println(PrimitiveIntTools.toString(arr));
    }

    public static void print(int[][] arr, String del1, String del2) {
        System.out.print(PrimitiveIntTools.toString(arr, del1, del2));
    }

    public static void print(int[][] arr) {
        System.out.print(PrimitiveIntTools.toString(arr));
    }

    public static int[] fromString(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        int[] arr = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            arr[i++] = Integer.valueOf(tok.nextToken());
        }
        return arr;
    }

    public static int[] expand(int[] arr, int expandTo) {
        Random rand = new Random();
        int additions = expandTo - arr.length;
        int[] res = arr;
        int i = 0;
        while (i < additions) {
            int copyIndex = rand.nextInt(res.length);
            res = PrimitiveIntTools.insert(res, copyIndex, res[copyIndex]);
            ++i;
        }
        return res;
    }

    public static int[] range(int start, int end, int step) {
        if (start > end) {
            throw new IllegalArgumentException("Invalid range: [" + start + ", " + end + ", " + step + "]");
        }
        int[] res = new int[(int)Math.ceil((double)(end - start) / (double)step)];
        if (res.length > 0) {
            res[0] = start;
            int i = 1;
            while (i < res.length) {
                res[i] = res[i - 1] + step;
                ++i;
            }
        }
        return res;
    }

    public static int[] range(int start, int end) {
        return PrimitiveIntTools.range(start, end, 1);
    }

    public static int[] range(int end) {
        return PrimitiveIntTools.range(0, end, 1);
    }

    public static void save(int[] arr, String file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(arr);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void save(int[][] arr, String file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(arr);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static int[][] loadMatrix(String file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            int[][] arr = (int[][])in.readObject();
            in.close();
            return arr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] load(String file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            int[] arr = (int[])in.readObject();
            in.close();
            return arr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] getIntArray(int v) {
        int[] res = new int[]{v};
        return res;
    }

    public static int[] getIntArray(int v1, int v2) {
        int[] res = new int[]{v1, v2};
        return res;
    }

    public static int[] getIntArray(int v1, int v2, int v3) {
        int[] res = new int[]{v1, v2, v3};
        return res;
    }

    public static int[] getRepeat(int val, int n) {
        int[] res = new int[n];
        Arrays.fill(res, val);
        return res;
    }

    public static int[] binSort(int[] indexes, int[] properties) {
        int min = PrimitiveIntTools.min(properties);
        int max = PrimitiveIntTools.max(properties);
        int nbins = max - min + 1;
        LinkedList[] bins = new LinkedList[nbins];
        int i = 0;
        while (i < bins.length) {
            bins[i] = new LinkedList();
            ++i;
        }
        i = 0;
        while (i < indexes.length) {
            bins[properties[i] - min].add(new Integer(indexes[i]));
            ++i;
        }
        int[] result = new int[indexes.length];
        int i2 = 0;
        int k = 0;
        while (i2 < bins.length) {
            Iterator it = bins[i2].iterator();
            while (it.hasNext()) {
                result[k++] = (Integer)it.next();
            }
            ++i2;
        }
        return result;
    }

    public static int[] smallestIndexes(int[] arr, int n) {
        return PrimitiveDoubleTools.smallestIndexes(PrimitiveIntTools.toDouble(arr), n);
    }

    public static int[] smallest(int[] arr, int n) {
        return PrimitiveIntTools.subarray(arr, PrimitiveIntTools.smallestIndexes(arr, n));
    }

    public static int[] largestIndexes(int[] arr, int n) {
        return PrimitiveDoubleTools.largestIndexes(PrimitiveIntTools.toDouble(arr), n);
    }

    public static int[] largest(int[] arr, int n) {
        return PrimitiveIntTools.subarray(arr, PrimitiveIntTools.largestIndexes(arr, n));
    }
}

