/*
 * Decompiled with CFR 0.152.
 */
package stallone.intsequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import stallone.api.ints.IIntArray;
import stallone.api.intsequence.IIntReader;
import stallone.api.intsequence.IIntSequenceLoader;

public class IntSequencesFileLoader
implements IIntSequenceLoader {
    private IIntReader loader;
    private ArrayList<String> sources = new ArrayList();
    private int currentSource;
    private boolean isOpen;
    private ArrayList<DataSequenceInfo> info = new ArrayList();
    private int totalSize = 0;
    private long largestMemorySize = 0L;
    private long totalMemorySize = 0L;

    @Override
    public void setLoader(IIntReader _loader) {
        this.loader = _loader;
    }

    @Override
    public void addSource(String link) {
        this.sources.add(link);
    }

    @Override
    public void scan() throws IOException {
        for (String s : this.sources) {
            this.loader.setSource(s);
            this.loader.open();
            this.loader.scan();
            DataSequenceInfo ds = new DataSequenceInfo();
            ds.memorySize = this.loader.memorySize();
            ds.size = this.loader.size();
            this.info.add(ds);
            this.totalSize += ds.size;
            if (ds.memorySize > this.largestMemorySize) {
                this.largestMemorySize = ds.memorySize;
            }
            this.totalMemorySize += ds.memorySize;
            this.loader.close();
        }
    }

    @Override
    public int numberOfSequences() {
        return this.info.size();
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public int size(int trajIndex) {
        return this.info.get((int)trajIndex).size;
    }

    @Override
    public Iterable<Integer> getSingleIntLoader() {
        return new SingleIntIterable();
    }

    @Override
    public Iterable<IIntArray> getSingleSequenceLoader() {
        return new SingleSequenceIterable();
    }

    @Override
    public long memorySizeOfSingleSequence(int index) {
        return this.info.get((int)index).memorySize;
    }

    @Override
    public long memorySizeOfLargestSequence() {
        return this.largestMemorySize;
    }

    @Override
    public long memorySizeTotal() {
        return this.totalMemorySize;
    }

    @Override
    public int load(int sequenceIndex, int frameIndex) throws IOException {
        if (this.currentSource != sequenceIndex) {
            this.loader.close();
            this.loader.setSource(this.sources.get(sequenceIndex));
            this.loader.open();
        }
        if (!this.isOpen) {
            this.loader.open();
        }
        return this.loader.get(frameIndex);
    }

    @Override
    public IIntArray loadSequence(int sequenceIndex) throws IOException {
        if (this.currentSource != sequenceIndex) {
            this.loader.close();
            this.loader.setSource(this.sources.get(sequenceIndex));
            this.loader.open();
        }
        if (!this.isOpen) {
            this.loader.open();
        }
        return this.loader.load();
    }

    @Override
    public List<IIntArray> loadAll() throws IOException {
        ArrayList<IIntArray> res = new ArrayList<IIntArray>();
        for (String s : this.sources) {
            this.loader.setSource(s);
            this.loader.open();
            res.add(this.loader.load());
            this.loader.close();
        }
        return res;
    }

    class DataSequenceInfo {
        protected int size;
        protected long memorySize;

        DataSequenceInfo() {
        }
    }

    class SingleDataIterator
    implements Iterator<Integer> {
        private int itraj = 0;
        private int iindex = 0;

        public SingleDataIterator() {
            try {
                IntSequencesFileLoader.this.loader.setSource((String)IntSequencesFileLoader.this.sources.get(0));
                IntSequencesFileLoader.this.loader.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.itraj < IntSequencesFileLoader.this.numberOfSequences() - 1 || this.itraj == IntSequencesFileLoader.this.numberOfSequences() - 1 && this.iindex < IntSequencesFileLoader.this.size(this.itraj);
        }

        @Override
        public Integer next() {
            Integer res = IntSequencesFileLoader.this.loader.get(this.iindex);
            try {
                this.advance();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return res;
        }

        private void advance() throws IOException {
            ++this.iindex;
            if (this.iindex >= IntSequencesFileLoader.this.size(this.itraj)) {
                ++this.itraj;
                IntSequencesFileLoader.this.loader.close();
                if (this.itraj < IntSequencesFileLoader.this.numberOfSequences()) {
                    IntSequencesFileLoader.this.loader.setSource((String)IntSequencesFileLoader.this.sources.get(this.itraj));
                    IntSequencesFileLoader.this.loader.open();
                }
                this.iindex = 0;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class SingleIntIterable
    implements Iterable<Integer> {
        SingleIntIterable() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return new SingleDataIterator();
        }
    }

    class SingleSequenceIterable
    implements Iterable<IIntArray> {
        SingleSequenceIterable() {
        }

        @Override
        public Iterator<IIntArray> iterator() {
            return new SingleSequenceIterator();
        }
    }

    class SingleSequenceIterator
    implements Iterator<IIntArray> {
        private int itraj = 0;

        public SingleSequenceIterator() {
            try {
                IntSequencesFileLoader.this.loader.setSource((String)IntSequencesFileLoader.this.sources.get(0));
                IntSequencesFileLoader.this.loader.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.itraj < IntSequencesFileLoader.this.numberOfSequences();
        }

        @Override
        public IIntArray next() {
            try {
                IntSequencesFileLoader.this.loader.close();
                IIntArray res = IntSequencesFileLoader.this.loader.load();
                ++this.itraj;
                if (this.itraj < IntSequencesFileLoader.this.numberOfSequences()) {
                    IntSequencesFileLoader.this.loader.setSource((String)IntSequencesFileLoader.this.sources.get(this.itraj));
                    IntSequencesFileLoader.this.loader.open();
                }
                return res;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

