/*
 * Decompiled with CFR 0.152.
 */
package stallone.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import stallone.api.strings.Strings;
import stallone.ints.PrimitiveIntTools;
import stallone.io.CachedAsciiFileReader;

public class BlockFileReader
extends CachedAsciiFileReader {
    private final int WORDTYPE_STRING = 0;
    private final int WORDTYPE_DOUBLE = 1;
    private final int WORDTYPE_INT = 2;
    private List<Block> blocks = new ArrayList<Block>();
    private Block currentBlock = null;
    private int currentLineNumber = -1;
    private String[] currentWords = null;

    public BlockFileReader(String filename) throws FileNotFoundException, IOException {
        super(filename);
    }

    @Override
    protected boolean scanLine(String textline, int currentLineNumber) {
        int[] types = this.getWordTypes(textline);
        if (this.currentBlock == null) {
            this.currentBlock = new Block(types, currentLineNumber);
        } else if (!this.equal(this.currentBlock.types, types)) {
            this.currentBlock.setLastLine(currentLineNumber - 1);
            this.blocks.add(this.currentBlock);
            this.currentBlock = new Block(types, currentLineNumber);
        }
        return true;
    }

    @Override
    protected void scanEnd(int currentLineNumber) {
        this.currentBlock.setLastLine(currentLineNumber - 1);
        this.blocks.add(this.currentBlock);
    }

    private int getWordType(String word) {
        if (Strings.util.isInt(word)) {
            return 2;
        }
        if (Strings.util.isDouble(word)) {
            return 1;
        }
        return 0;
    }

    private int[] getWordTypes(String line) {
        String[] words = Strings.util.split(line);
        int[] types = new int[words.length];
        int i = 0;
        while (i < types.length) {
            types[i] = this.getWordType(words[i]);
            ++i;
        }
        return types;
    }

    private boolean equal(int[] t1, int[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        int i = 0;
        while (i < t1.length) {
            if (t1[i] != t2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Block getBlock(int line) {
        int b = 0;
        while (b < this.blocks.size()) {
            Block block = this.blocks.get(b);
            if (line >= block.start && line < block.end) {
                return block;
            }
            ++b;
        }
        return null;
    }

    private String typeToString(int type) {
        if (type == 0) {
            return "str ";
        }
        if (type == 2) {
            return "int ";
        }
        if (type == 1) {
            return "double ";
        }
        return null;
    }

    private String typesToString(int[] types) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            strb.append(this.typeToString(types[i]));
            ++i;
        }
        return strb.toString();
    }

    private void checkAvailable(int[] types, int word) {
        if (word >= types.length) {
            throw new IllegalArgumentException("Trying to get word with index " + word + " from a line which has only " + types.length + " words of type: " + this.typesToString(types));
        }
    }

    private void checkRequest(int line, int word, int expectedType) {
        Block b = this.getBlock(line);
        this.checkAvailable(b.types, word);
        if (b.types[word] < expectedType) {
            throw new IllegalArgumentException("Trying to read type " + this.typeToString(expectedType) + " in line " + line + ", word " + word + ", but found wrong type " + this.typeToString(b.types[word]));
        }
        this.readLine(line);
    }

    private void checkLineArrayRequest(int line, int expectedType) {
        Block b = this.getBlock(line);
        int word = 0;
        while (word < b.types.length) {
            if (b.types[word] < expectedType) {
                throw new IllegalArgumentException("Trying to read type " + this.typeToString(expectedType) + " in line " + line + ", word " + word + ", but found wrong type " + this.typeToString(b.types[word]));
            }
            ++word;
        }
        this.readLine(line);
    }

    private void readLine(int line) {
        if (line != this.currentLineNumber) {
            this.currentLineNumber = line;
            this.currentWords = Strings.util.split(super.getLine(line));
        }
    }

    public int getInt(int line, int word) {
        this.checkRequest(line, word, 2);
        return Strings.util.toInt(this.currentWords[word]);
    }

    public double getDouble(int line, int word) {
        this.checkRequest(line, word, 1);
        return Strings.util.toDouble(this.currentWords[word]);
    }

    public String getWord(int line, int word) {
        this.checkRequest(line, word, 0);
        return this.currentWords[word];
    }

    public int[] getIntRow(int line) {
        this.checkLineArrayRequest(line, 2);
        return Strings.util.toIntArray(this.currentWords);
    }

    public double[] getDoubleRow(int line) {
        this.checkLineArrayRequest(line, 1);
        return Strings.util.toDoubleArray(this.currentWords);
    }

    public int countColumnsIntRow(int line) {
        this.readLine(line);
        return this.currentWords.length;
    }

    public int countElementsInColumn(int column, int expectedType) {
        int size = 0;
        for (Block b : this.blocks) {
            if (b.types.length <= column || b.types[column] < expectedType) continue;
            size += b.length;
        }
        return size;
    }

    public int[] getIntColumn(int column) {
        int[] res = new int[this.countElementsInColumn(column, 2)];
        int i = 0;
        for (Block b : this.blocks) {
            if (b.types.length <= column || b.types[column] < 2) continue;
            int j = 0;
            while (j < b.length) {
                res[i++] = this.getInt(b.start + j, column);
                ++j;
            }
        }
        return res;
    }

    public double[] getDoubleColumn(int column) {
        double[] res = new double[this.countElementsInColumn(column, 1)];
        int i = 0;
        for (Block b : this.blocks) {
            if (b.types.length <= column || b.types[column] < 1) continue;
            int j = 0;
            while (j < b.length) {
                res[i++] = this.getDouble(b.start + j, column);
                ++j;
            }
        }
        return res;
    }

    public String[] getColumn(int column) {
        String[] res = new String[this.countElementsInColumn(column, 0)];
        int i = 0;
        for (Block b : this.blocks) {
            if (b.types.length <= column) continue;
            int j = 0;
            while (j < b.length) {
                res[i++] = this.getWord(b.start + j, column);
                ++j;
            }
        }
        return res;
    }

    private Block generalizeBlock(Block b, int expectedType) {
        Block res = b.copy();
        int i = 0;
        while (i < res.types.length) {
            res.types[i] = Math.min(res.types[i], expectedType);
            ++i;
        }
        return res;
    }

    private List<Block> mergeConsistentBlocks(int expectedType) {
        ArrayList<Block> res = new ArrayList<Block>();
        Block currentBlock = this.generalizeBlock(this.blocks.get(0), expectedType);
        res.add(currentBlock);
        int i = 1;
        while (i < this.blocks.size()) {
            Block candidate = this.generalizeBlock(this.blocks.get(i), expectedType);
            if (PrimitiveIntTools.equal(currentBlock.types, candidate.types)) {
                currentBlock.end += candidate.length;
                currentBlock.length += candidate.length;
            } else {
                currentBlock = candidate;
                res.add(candidate);
            }
            ++i;
        }
        return res;
    }

    private Block getLargestBlock(int expectedType) {
        Block largest = null;
        int size = 0;
        List<Block> mergedBlocks = this.mergeConsistentBlocks(expectedType);
        for (Block b : mergedBlocks) {
            int nwords = 0;
            int i = 0;
            while (i < b.types.length) {
                if (b.types[i] >= expectedType) {
                    ++nwords;
                }
                ++i;
            }
            int currentSize = nwords * b.length;
            if (currentSize <= size) continue;
            size = currentSize;
            largest = b;
        }
        return largest;
    }

    private int[] consistentColumns(Block b, int expectedType) {
        int[] res = new int[b.types.length];
        int n = 0;
        int i = 0;
        while (i < b.types.length) {
            if (b.types[i] >= expectedType) {
                res[i] = i;
                ++n;
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, n);
    }

    private boolean areBlocksConsistent(Block b1, Block b2, int expectedType) {
        int[] c1 = this.consistentColumns(b1, expectedType);
        int[] c2 = this.consistentColumns(b2, expectedType);
        return PrimitiveIntTools.equal(c1, c2);
    }

    private int[] selectTypes(int[] types, int expectedType) {
        int n = 0;
        int i = 0;
        while (i < types.length) {
            if (types[i] >= expectedType) {
                ++n;
            }
            ++i;
        }
        int[] res = new int[n];
        int j = 0;
        int i2 = 0;
        while (i2 < types.length) {
            if (types[i2] >= expectedType) {
                res[j++] = i2;
            }
            ++i2;
        }
        return res;
    }

    public int[] getLargestNumberBlockDimensions() {
        return this.getLargestDoubleBlockDimensions();
    }

    public int[] getLargestDoubleBlockDimensions() {
        Block b = this.getLargestBlock(1);
        if (b == null) {
            int[] res = new int[2];
            return res;
        }
        int[] res = new int[]{b.length, this.selectTypes(b.types, 1).length};
        return res;
    }

    public int[] getLargestIntBlockDimensions() {
        Block b = this.getLargestBlock(2);
        if (b == null) {
            int[] res = new int[2];
            return res;
        }
        int[] res = new int[]{b.length, this.selectTypes(b.types, 2).length};
        return res;
    }

    public int[][] getLargestIntBlock() {
        Block b = this.getLargestBlock(2);
        if (b == null) {
            return null;
        }
        int[] indexes = this.selectTypes(b.types, 2);
        int[][] res = new int[b.length][indexes.length];
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < indexes.length) {
                res[i][j] = this.getInt(i + b.start, indexes[j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public double[][] getLargestDoubleBlock() {
        Block b = this.getLargestBlock(1);
        if (b == null) {
            return null;
        }
        int[] indexes = this.selectTypes(b.types, 1);
        double[][] res = new double[b.length][indexes.length];
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < indexes.length) {
                res[i][j] = this.getDouble(i + b.start, indexes[j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public String[][] getLargestBlock() {
        Block b = this.getLargestBlock(0);
        String[][] res = new String[b.length][b.types.length];
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < res[i].length) {
                res[i][j] = this.getWord(i + b.start, j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    private class Block {
        int[] types;
        int start;
        int end;
        int length;

        public Block(int[] _types, int _start) {
            this.types = _types;
            this.start = _start;
        }

        public void setLastLine(int lastLine) {
            this.end = lastLine + 1;
            this.length = lastLine - this.start + 1;
        }

        public Block copy() {
            Block b = new Block(PrimitiveIntTools.copy(this.types), this.start);
            b.end = this.end;
            b.length = this.length;
            return b;
        }

        public String toString() {
            return "block " + this.start + "-" + this.end + ". types: " + PrimitiveIntTools.toString(this.types, ",") + "\n";
        }
    }
}

