/*
 * Decompiled with CFR 0.152.
 */
package stallone.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import stallone.api.io.IO;
import stallone.io.WildcardFilter;

public class RecursiveFileList {
    private File startingDirectory;
    private List<File> allFiles;
    private String filter;
    private List<File> selectedFiles;

    public RecursiveFileList(String startingDirectory) throws FileNotFoundException {
        this(new File(startingDirectory));
    }

    public RecursiveFileList(String startingDirectory, String _filter) throws FileNotFoundException {
        this(new File(startingDirectory), _filter);
    }

    public RecursiveFileList(File _startingDirectory) throws FileNotFoundException {
        this(_startingDirectory, null);
    }

    public RecursiveFileList(File _startingDirectory, String _filter) throws FileNotFoundException {
        this.startingDirectory = _startingDirectory;
        this.validateDirectory(this.startingDirectory);
        this.allFiles = this.listFilesRecursiveUnsorted(this.startingDirectory);
        Collections.sort(this.allFiles);
        this.filter = _filter;
        this.employFilter(_filter);
    }

    private List<File> listFilesRecursiveUnsorted(File startingDirectory) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = startingDirectory.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = this.listFilesRecursiveUnsorted(file);
            result.addAll(deeperList);
        }
        return result;
    }

    private void employFilter(String filter) {
        if (filter == null) {
            this.selectedFiles = this.allFiles;
        } else {
            this.selectedFiles = new ArrayList<File>();
            WildcardFilter wcfilter = new WildcardFilter(filter);
            for (File f : this.allFiles) {
                if (!wcfilter.accept(f)) continue;
                this.selectedFiles.add(f);
            }
        }
    }

    private void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public int numberOfFiles() {
        return this.selectedFiles.size();
    }

    public List<File> getFiles() {
        return this.selectedFiles;
    }

    public List<String> getAbsolutePaths() {
        return IO.util.toStrings(this.selectedFiles);
    }

    public List<String> getLocalPaths() {
        ArrayList<String> localpaths = new ArrayList<String>();
        String startingDirectoryPath = this.startingDirectory.getAbsolutePath();
        for (File f : this.selectedFiles) {
            String lp = f.getAbsolutePath();
            if (lp.startsWith(startingDirectoryPath)) {
                lp = lp.substring(startingDirectoryPath.length());
                while (lp.startsWith("/")) {
                    lp = lp.substring(1);
                }
            } else {
                throw new RuntimeException("Should not be here. Inconsistency in file names");
            }
            localpaths.add(lp);
        }
        return localpaths;
    }

    public List<String> getLocalSubDirectoryPaths() {
        HashSet<String> subdirs = new HashSet<String>();
        List<String> localpaths = this.getLocalPaths();
        for (String s : localpaths) {
            if (!s.contains("/")) continue;
            subdirs.add(s.substring(0, s.lastIndexOf("/")));
        }
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(subdirs);
        return res;
    }
}

