/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.api.mc.IMarkovChain;
import stallone.ints.PrimitiveIntArray;
import stallone.ints.PrimitiveIntTools;
import stallone.stat.DiscreteDistribution;
import stallone.stat.DiscreteDistributions;

public class MarkovChain
implements IMarkovChain {
    protected IDoubleArray p0;
    protected IDoubleArray T;
    protected DiscreteDistributions dd;
    private boolean fixedStartingState = false;
    private int s = 0;
    private DiscreteDistribution p0dist;
    private int nskip = 1;

    protected MarkovChain() {
    }

    public MarkovChain(IDoubleArray _T) {
        this.T = _T;
        this.dd = new DiscreteDistributions(_T);
    }

    public MarkovChain(IDoubleArray _startingDistribution, IDoubleArray _T) {
        this.T = _T;
        this.dd = new DiscreteDistributions(_T);
        this.p0 = _startingDistribution;
        this.p0dist = new DiscreteDistribution(this.p0);
    }

    @Override
    public void setStartingState(int _s) {
        this.fixedStartingState = true;
        this.s = _s;
    }

    @Override
    public void setStartingDistribution(IDoubleArray _p0) {
        this.fixedStartingState = false;
        this.p0 = _p0;
        this.p0dist = new DiscreteDistribution(this.p0);
    }

    @Override
    public IDoubleArray getTransitionMatrix() {
        return this.T;
    }

    private int startingState() {
        if (this.fixedStartingState) {
            return this.s;
        }
        if (this.p0 == null) {
            this.p0 = API.msm.stationaryDistribution(this.T);
            this.p0dist = new DiscreteDistribution(this.p0);
        }
        return this.p0dist.sample();
    }

    private void setNSkip(int _nskip) {
        this.nskip = _nskip;
    }

    @Override
    public IIntArray randomTrajectory(int N) {
        int c;
        int[] res = new int[N / this.nskip];
        res[0] = c = this.startingState();
        int k = 1;
        int i = 1;
        while (i < N) {
            c = this.dd.sample(c);
            if (i % this.nskip == 0) {
                res[k++] = c;
            }
            ++i;
        }
        return new PrimitiveIntArray(res);
    }

    @Override
    public IIntArray randomTrajectoryToState(int[] endStates) {
        IIntList res = Ints.create.list(0);
        int c = this.startingState();
        res.append(c);
        int i = 0;
        while (!PrimitiveIntTools.contains(endStates, c)) {
            c = this.dd.sample(c);
            if (i % this.nskip == 0) {
                res.append(c);
            }
            ++i;
        }
        return res;
    }

    @Override
    public void printRandomTrajectory(int N) {
        int c = this.startingState();
        System.out.println(c);
        int i = 0;
        while (i < N) {
            c = this.dd.sample(c);
            System.out.println(c);
            ++i;
        }
    }
}

